/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.nbt;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.nbt.NbtAdapter;
import iskallia.vault.core.net.BitBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class IntArrayNbtAdapter
extends NbtAdapter<IntArrayTag> {
    public IntArrayNbtAdapter(boolean nullable) {
        super(nullable);
    }

    public IntArrayNbtAdapter asNullable() {
        return new IntArrayNbtAdapter(this.isNullable());
    }

    @Override
    protected void writeTagBits(IntArrayTag value, BitBuffer buffer) {
        Adapters.INT_ARRAY.writeBits(value.m_128648_(), buffer);
    }

    @Override
    protected IntArrayTag readTagBits(BitBuffer buffer) {
        return new IntArrayTag(Adapters.INT_ARRAY.readBits(buffer).orElseThrow());
    }

    @Override
    protected void writeTagBytes(IntArrayTag value, ByteBuf buffer) {
        Adapters.INT_ARRAY.writeBytes(value.m_128648_(), buffer);
    }

    @Override
    protected IntArrayTag readTagBytes(ByteBuf buffer) {
        return new IntArrayTag(Adapters.INT_ARRAY.readBytes(buffer).orElseThrow());
    }

    @Override
    protected void writeTagData(IntArrayTag value, DataOutput data) throws IOException {
        Adapters.INT_ARRAY.writeData(value.m_128648_(), data);
    }

    @Override
    protected IntArrayTag readTagData(DataInput data) throws IOException {
        return new IntArrayTag(Adapters.INT_ARRAY.readData(data).orElseThrow());
    }

    @Override
    protected Tag writeTagNbt(IntArrayTag value) {
        return value.m_6426_();
    }

    @Override
    @Nullable
    protected IntArrayTag readTagNbt(Tag nbt) {
        IntArrayTag intArrayTag;
        if (nbt instanceof IntArrayTag) {
            IntArrayTag tag = (IntArrayTag)nbt;
            intArrayTag = tag.m_6426_();
        } else {
            intArrayTag = null;
        }
        return intArrayTag;
    }

    @Override
    protected JsonElement writeTagJson(IntArrayTag value) {
        return Adapters.INT_ARRAY.writeJson(value.m_128648_()).map(array -> {
            JsonArray copy = new JsonArray();
            copy.add("I");
            for (int i = 1; i < array.size(); ++i) {
                copy.add(array.get(i));
            }
            return copy;
        }).orElse(null);
    }

    @Override
    @Nullable
    protected IntArrayTag readTagJson(JsonElement json) {
        if (json instanceof JsonArray) {
            JsonPrimitive primitive;
            JsonElement jsonElement;
            JsonArray array = (JsonArray)json;
            if (array.size() > 0 && (jsonElement = array.get(0)) instanceof JsonPrimitive && (primitive = (JsonPrimitive)jsonElement).getAsString().equals("I")) {
                JsonArray copy = new JsonArray();
                for (int i = 1; i < array.size(); ++i) {
                    copy.add(array.get(i));
                }
                array = copy;
            }
            return Adapters.INT_ARRAY.readJson(array).map(IntArrayTag::new).orElse(null);
        }
        return null;
    }
}

