/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.nbt;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.nbt.NbtAdapter;
import iskallia.vault.core.net.BitBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class LongArrayNbtAdapter
extends NbtAdapter<LongArrayTag> {
    public LongArrayNbtAdapter(boolean nullable) {
        super(nullable);
    }

    public LongArrayNbtAdapter asNullable() {
        return new LongArrayNbtAdapter(this.isNullable());
    }

    @Override
    protected void writeTagBits(LongArrayTag value, BitBuffer buffer) {
        Adapters.LONG_ARRAY.writeBits(value.m_128851_(), buffer);
    }

    @Override
    protected LongArrayTag readTagBits(BitBuffer buffer) {
        return new LongArrayTag(Adapters.LONG_ARRAY.readBits(buffer).orElseThrow());
    }

    @Override
    protected void writeTagBytes(LongArrayTag value, ByteBuf buffer) {
        Adapters.LONG_ARRAY.writeBytes(value.m_128851_(), buffer);
    }

    @Override
    protected LongArrayTag readTagBytes(ByteBuf buffer) {
        return new LongArrayTag(Adapters.LONG_ARRAY.readBytes(buffer).orElseThrow());
    }

    @Override
    protected void writeTagData(LongArrayTag value, DataOutput data) throws IOException {
        Adapters.LONG_ARRAY.writeData(value.m_128851_(), data);
    }

    @Override
    protected LongArrayTag readTagData(DataInput data) throws IOException {
        return new LongArrayTag(Adapters.LONG_ARRAY.readData(data).orElseThrow());
    }

    @Override
    protected Tag writeTagNbt(LongArrayTag value) {
        return value.m_6426_();
    }

    @Override
    @Nullable
    protected LongArrayTag readTagNbt(Tag nbt) {
        LongArrayTag longArrayTag;
        if (nbt instanceof LongArrayTag) {
            LongArrayTag tag = (LongArrayTag)nbt;
            longArrayTag = tag.m_6426_();
        } else {
            longArrayTag = null;
        }
        return longArrayTag;
    }

    @Override
    protected JsonElement writeTagJson(LongArrayTag value) {
        return Adapters.LONG_ARRAY.writeJson(value.m_128851_()).map(array -> {
            JsonArray copy = new JsonArray();
            copy.add("L");
            for (int i = 1; i < array.size(); ++i) {
                copy.add(array.get(i));
            }
            return copy;
        }).orElse(null);
    }

    @Override
    @Nullable
    protected LongArrayTag readTagJson(JsonElement json) {
        if (json instanceof JsonArray) {
            JsonPrimitive primitive;
            JsonElement jsonElement;
            JsonArray array = (JsonArray)json;
            if (array.size() > 0 && (jsonElement = array.get(0)) instanceof JsonPrimitive && (primitive = (JsonPrimitive)jsonElement).getAsString().equals("L")) {
                JsonArray copy = new JsonArray();
                for (int i = 1; i < array.size(); ++i) {
                    copy.add(array.get(i));
                }
                array = copy;
            }
            return Adapters.LONG_ARRAY.readJson(array).map(LongArrayTag::new).orElse(null);
        }
        return null;
    }
}

