/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.nbt;

import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.nbt.NbtAdapter;
import iskallia.vault.core.data.adapter.number.NumberAdapter;
import iskallia.vault.core.data.adapter.number.NumericAdapter;
import iskallia.vault.core.net.BitBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class NumericNbtAdapter
extends NbtAdapter<NumericTag> {
    public NumericNbtAdapter(boolean nullable) {
        super(nullable);
    }

    public NumericNbtAdapter asNullable() {
        return new NumericNbtAdapter(this.isNullable());
    }

    @Override
    protected void writeTagBits(NumericTag value, BitBuffer buffer) {
        Adapters.NUMERIC.writeBits(value.m_8103_(), buffer);
    }

    @Override
    protected NumericTag readTagBits(BitBuffer buffer) {
        NumericTag numeric;
        Tag tag = NumericAdapter.wrap((Number)Adapters.NUMERIC.readBits(buffer).orElseThrow());
        return tag instanceof NumericTag ? (numeric = (NumericTag)tag) : null;
    }

    @Override
    protected void writeTagBytes(NumericTag value, ByteBuf buffer) {
        Adapters.NUMERIC.writeBytes(value.m_8103_(), buffer);
    }

    @Override
    protected NumericTag readTagBytes(ByteBuf buffer) {
        NumericTag numeric;
        Tag tag = NumericAdapter.wrap((Number)Adapters.NUMERIC.readBytes(buffer).orElseThrow());
        return tag instanceof NumericTag ? (numeric = (NumericTag)tag) : null;
    }

    @Override
    protected void writeTagData(NumericTag value, DataOutput data) throws IOException {
        Adapters.NUMERIC.writeData(value.m_8103_(), data);
    }

    @Override
    protected NumericTag readTagData(DataInput data) throws IOException {
        NumericTag numeric;
        Tag tag = NumericAdapter.wrap((Number)Adapters.NUMERIC.readData(data).orElseThrow());
        return tag instanceof NumericTag ? (numeric = (NumericTag)tag) : null;
    }

    @Override
    protected Tag writeTagNbt(NumericTag value) {
        return value;
    }

    @Override
    @Nullable
    protected NumericTag readTagNbt(Tag nbt) {
        NumericTag tag;
        return nbt instanceof NumericTag ? (tag = (NumericTag)nbt) : null;
    }

    @Override
    protected JsonElement writeTagJson(NumericTag value) {
        return Adapters.NUMERIC.writeJson(value.m_8103_()).orElseThrow();
    }

    @Override
    @Nullable
    protected NumericTag readTagJson(JsonElement json) {
        NumericTag numeric;
        Tag tag = Adapters.NUMERIC.readJson(json).map(NumberAdapter::wrap).orElse(null);
        return tag instanceof NumericTag ? (numeric = (NumericTag)tag) : null;
    }
}

