/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.nbt;

import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.nbt.NbtAdapter;
import iskallia.vault.core.net.BitBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class StringNbtAdapter
extends NbtAdapter<StringTag> {
    public StringNbtAdapter(boolean nullable) {
        super(nullable);
    }

    public StringNbtAdapter asNullable() {
        return new StringNbtAdapter(this.isNullable());
    }

    @Override
    protected void writeTagBits(StringTag value, BitBuffer buffer) {
        Adapters.UTF_8.writeBits(value.m_7916_(), buffer);
    }

    @Override
    protected StringTag readTagBits(BitBuffer buffer) {
        return StringTag.m_129297_((String)Adapters.UTF_8.readBits(buffer).orElseThrow());
    }

    @Override
    protected void writeTagBytes(StringTag value, ByteBuf buffer) {
        Adapters.UTF_8.writeBytes(value.m_7916_(), buffer);
    }

    @Override
    protected StringTag readTagBytes(ByteBuf buffer) {
        return StringTag.m_129297_((String)Adapters.UTF_8.readBytes(buffer).orElseThrow());
    }

    @Override
    protected void writeTagData(StringTag value, DataOutput data) throws IOException {
        Adapters.UTF_8.writeData(value.m_7916_(), data);
    }

    @Override
    protected StringTag readTagData(DataInput data) throws IOException {
        return StringTag.m_129297_((String)Adapters.UTF_8.readData(data).orElseThrow());
    }

    @Override
    protected Tag writeTagNbt(StringTag value) {
        return value;
    }

    @Override
    @Nullable
    protected StringTag readTagNbt(Tag nbt) {
        StringTag tag;
        return nbt instanceof StringTag ? (tag = (StringTag)nbt) : null;
    }

    @Override
    protected JsonElement writeTagJson(StringTag value) {
        return Adapters.UTF_8.writeJson(value.m_7916_()).orElseThrow();
    }

    @Override
    @Nullable
    protected StringTag readTagJson(JsonElement json) {
        return Adapters.UTF_8.readJson(json).map(StringTag::m_129297_).orElse(null);
    }
}

