/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.number;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.number.NumberAdapter;
import iskallia.vault.core.net.BitBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nullable;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class BigDecimalAdapter
extends NumberAdapter<BigDecimal> {
    public BigDecimalAdapter(boolean nullable) {
        super(nullable);
    }

    public BigDecimalAdapter asNullable() {
        return new BigDecimalAdapter(true);
    }

    @Override
    protected void writeNumberBits(BigDecimal value, BitBuffer buffer) {
        Adapters.BIG_INTEGER.writeBits(value.unscaledValue(), buffer);
        Adapters.INT.writeBits(value.scale(), buffer);
    }

    @Override
    protected BigDecimal readNumberBits(BitBuffer buffer) {
        return new BigDecimal((BigInteger)Adapters.BIG_INTEGER.readBits(buffer).orElseThrow(), (Integer)Adapters.INT.readBits(buffer).orElseThrow());
    }

    @Override
    protected void writeNumberBytes(BigDecimal value, ByteBuf buffer) {
        Adapters.BIG_INTEGER.writeBytes(value.unscaledValue(), buffer);
        Adapters.INT.writeBytes(value.scale(), buffer);
    }

    @Override
    protected BigDecimal readNumberBytes(ByteBuf buffer) {
        return new BigDecimal((BigInteger)Adapters.BIG_INTEGER.readBytes(buffer).orElseThrow(), (Integer)Adapters.INT.readBytes(buffer).orElseThrow());
    }

    @Override
    protected void writeNumberData(BigDecimal value, DataOutput data) throws IOException {
        Adapters.BIG_INTEGER.writeData(value.unscaledValue(), data);
        Adapters.INT.writeData(value.scale(), data);
    }

    @Override
    protected BigDecimal readNumberData(DataInput data) throws IOException {
        return new BigDecimal((BigInteger)Adapters.BIG_INTEGER.readData(data).orElseThrow(), (Integer)Adapters.INT.readData(data).orElseThrow());
    }

    @Override
    protected Tag writeNumberNbt(BigDecimal value) {
        return BigDecimalAdapter.wrap(BigDecimalAdapter.reduce(value));
    }

    @Override
    @Nullable
    protected BigDecimal readNumberNbt(Tag nbt) {
        ListTag list;
        if (nbt instanceof NumericTag) {
            NumericTag numeric = (NumericTag)nbt;
            return BigDecimal.valueOf(numeric.m_7046_());
        }
        if (nbt instanceof ListTag && (list = (ListTag)nbt).size() == 1) {
            return this.readNumberNbt(list.get(0));
        }
        if (nbt instanceof StringTag) {
            StringTag string = (StringTag)nbt;
            return BigDecimalAdapter.parse(string.m_7916_()).map(number -> {
                BigDecimal value;
                return number instanceof BigDecimal ? (value = (BigDecimal)number) : BigDecimal.valueOf(number.doubleValue());
            }).orElse(null);
        }
        return null;
    }

    @Override
    protected JsonElement writeNumberJson(BigDecimal value) {
        return new JsonPrimitive((Number)value);
    }

    @Override
    @Nullable
    protected BigDecimal readNumberJson(JsonElement json) {
        JsonArray array;
        if (json instanceof JsonObject) {
            return null;
        }
        if (json instanceof JsonArray && (array = (JsonArray)json).size() == 1) {
            return this.readNumberJson(array.get(0));
        }
        if (json instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)json;
            if (primitive.isNumber()) {
                return primitive.getAsBigDecimal();
            }
            if (primitive.isString()) {
                return BigDecimalAdapter.parse(primitive.getAsString()).map(number -> {
                    BigDecimal value;
                    return number instanceof BigDecimal ? (value = (BigDecimal)number) : BigDecimal.valueOf(number.doubleValue());
                }).orElse(null);
            }
        }
        return null;
    }
}

