/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.number;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.ISimpleAdapter;
import iskallia.vault.core.net.BitBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;

public class CharAdapter
implements ISimpleAdapter<Character, Tag, JsonElement> {
    private final boolean nullable;

    public CharAdapter(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public CharAdapter asNullable() {
        return new CharAdapter(true);
    }

    @Override
    public final void writeBits(@Nullable Character value, BitBuffer buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            buffer.writeChar(value.charValue());
        }
    }

    @Override
    public final Optional<Character> readBits(BitBuffer buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(Character.valueOf(buffer.readChar()));
    }

    @Override
    public final void writeBytes(@Nullable Character value, ByteBuf buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            buffer.writeChar((int)value.charValue());
        }
    }

    @Override
    public final Optional<Character> readBytes(ByteBuf buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(Character.valueOf(buffer.readChar()));
    }

    @Override
    public void writeData(Character value, DataOutput data) throws IOException {
        if (this.nullable) {
            data.writeBoolean(value == null);
        }
        if (value != null) {
            data.writeChar(value.charValue());
        }
    }

    @Override
    public Optional<Character> readData(DataInput data) throws IOException {
        if (this.nullable && data.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(Character.valueOf(data.readChar()));
    }

    @Override
    public final Optional<Tag> writeNbt(@Nullable Character value) {
        return value == null ? Optional.empty() : Optional.of(ShortTag.m_129258_((short)((short)value.charValue())));
    }

    @Override
    public final Optional<Character> readNbt(@Nullable Tag nbt) {
        Optional<Character> optional;
        if (nbt instanceof ShortTag) {
            ShortTag tag = (ShortTag)nbt;
            optional = Optional.of(Character.valueOf((char)Short.toUnsignedInt(tag.m_7053_())));
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    public final Optional<JsonElement> writeJson(@Nullable Character value) {
        return value == null ? Optional.empty() : Optional.of(new JsonPrimitive(value));
    }

    @Override
    public final Optional<Character> readJson(@Nullable JsonElement json) {
        JsonPrimitive primitive;
        JsonArray array;
        if (json instanceof JsonArray && (array = (JsonArray)json).size() == 1) {
            return this.readJson(array.get(0));
        }
        if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString()) {
            return Optional.of(Character.valueOf(primitive.getAsString().charAt(0)));
        }
        return Optional.empty();
    }
}

