/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.number;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.number.NumberAdapter;
import iskallia.vault.core.net.BitBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class IntAdapter
extends NumberAdapter<Integer> {
    public IntAdapter(boolean nullable) {
        super(nullable);
    }

    public IntAdapter asNullable() {
        return new IntAdapter(true);
    }

    @Override
    protected void writeNumberBits(Integer value, BitBuffer buffer) {
        buffer.writeInt(value);
    }

    @Override
    protected Integer readNumberBits(BitBuffer buffer) {
        return buffer.readInt();
    }

    @Override
    protected void writeNumberBytes(Integer value, ByteBuf buffer) {
        buffer.writeInt(value.intValue());
    }

    @Override
    protected Integer readNumberBytes(ByteBuf buffer) {
        return buffer.readInt();
    }

    @Override
    protected void writeNumberData(Integer value, DataOutput data) throws IOException {
        data.writeInt(value);
    }

    @Override
    protected Integer readNumberData(DataInput data) throws IOException {
        return data.readInt();
    }

    @Override
    protected Tag writeNumberNbt(Integer value) {
        return IntAdapter.wrap(IntAdapter.reduce(value));
    }

    @Override
    @Nullable
    protected Integer readNumberNbt(Tag nbt) {
        ListTag list;
        if (nbt instanceof NumericTag) {
            NumericTag numeric = (NumericTag)nbt;
            return numeric.m_7047_();
        }
        if (nbt instanceof ListTag && (list = (ListTag)nbt).size() == 1) {
            return this.readNumberNbt(list.get(0));
        }
        if (nbt instanceof StringTag) {
            StringTag string = (StringTag)nbt;
            return IntAdapter.parse(string.m_7916_()).map(Number::intValue).orElse(null);
        }
        return null;
    }

    @Override
    protected JsonElement writeNumberJson(Integer value) {
        return new JsonPrimitive((Number)value);
    }

    @Override
    @Nullable
    protected Integer readNumberJson(JsonElement json) {
        JsonArray array;
        if (json instanceof JsonObject) {
            return null;
        }
        if (json instanceof JsonArray && (array = (JsonArray)json).size() == 1) {
            return this.readNumberJson(array.get(0));
        }
        if (json instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)json;
            if (primitive.isNumber()) {
                return primitive.getAsInt();
            }
            if (primitive.isString()) {
                return IntAdapter.parse(primitive.getAsString()).map(Number::intValue).orElse(null);
            }
        }
        return null;
    }
}

