/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.number;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.number.NumberAdapter;
import iskallia.vault.core.net.BitBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class LongAdapter
extends NumberAdapter<Long> {
    public LongAdapter(boolean nullable) {
        super(nullable);
    }

    public LongAdapter asNullable() {
        return new LongAdapter(true);
    }

    @Override
    protected void writeNumberBits(Long value, BitBuffer buffer) {
        buffer.writeLong(value);
    }

    @Override
    protected Long readNumberBits(BitBuffer buffer) {
        return buffer.readLong();
    }

    @Override
    protected void writeNumberBytes(Long value, ByteBuf buffer) {
        buffer.writeLong(value.longValue());
    }

    @Override
    protected Long readNumberBytes(ByteBuf buffer) {
        return buffer.readLong();
    }

    @Override
    protected void writeNumberData(Long value, DataOutput data) throws IOException {
        data.writeLong(value);
    }

    @Override
    protected Long readNumberData(DataInput data) throws IOException {
        return data.readLong();
    }

    @Override
    @Nullable
    protected Tag writeNumberNbt(Long value) {
        return LongAdapter.wrap(LongAdapter.reduce(value));
    }

    @Override
    @Nullable
    protected Long readNumberNbt(Tag nbt) {
        ListTag list;
        if (nbt instanceof NumericTag) {
            NumericTag numeric = (NumericTag)nbt;
            return numeric.m_7046_();
        }
        if (nbt instanceof ListTag && (list = (ListTag)nbt).size() == 1) {
            return this.readNumberNbt(list.get(0));
        }
        if (nbt instanceof StringTag) {
            StringTag string = (StringTag)nbt;
            return LongAdapter.parse(string.m_7916_()).map(Number::longValue).orElse(null);
        }
        return null;
    }

    @Override
    @Nullable
    protected JsonElement writeNumberJson(Long value) {
        return new JsonPrimitive((Number)value);
    }

    @Override
    @Nullable
    protected Long readNumberJson(JsonElement json) {
        JsonArray array;
        if (json instanceof JsonObject) {
            return null;
        }
        if (json instanceof JsonArray && (array = (JsonArray)json).size() == 1) {
            return this.readNumberJson(array.get(0));
        }
        if (json instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)json;
            if (primitive.isNumber()) {
                return primitive.getAsLong();
            }
            if (primitive.isString()) {
                return LongAdapter.parse(primitive.getAsString()).map(Number::longValue).orElse(null);
            }
        }
        return null;
    }
}

