/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.number;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.number.NumberAdapter;
import iskallia.vault.core.net.BitBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class ShortAdapter
extends NumberAdapter<Short> {
    public ShortAdapter(boolean nullable) {
        super(nullable);
    }

    public ShortAdapter asNullable() {
        return new ShortAdapter(true);
    }

    @Override
    protected void writeNumberBits(Short value, BitBuffer buffer) {
        buffer.writeShort(value);
    }

    @Override
    protected Short readNumberBits(BitBuffer buffer) {
        return buffer.readShort();
    }

    @Override
    protected void writeNumberBytes(Short value, ByteBuf buffer) {
        buffer.writeShort((int)value.shortValue());
    }

    @Override
    protected Short readNumberBytes(ByteBuf buffer) {
        return buffer.readShort();
    }

    @Override
    protected void writeNumberData(Short value, DataOutput data) throws IOException {
        data.writeShort(value.shortValue());
    }

    @Override
    protected Short readNumberData(DataInput data) throws IOException {
        return data.readShort();
    }

    @Override
    protected Tag writeNumberNbt(Short value) {
        return ShortAdapter.wrap(ShortAdapter.reduce(value));
    }

    @Override
    @Nullable
    protected Short readNumberNbt(Tag nbt) {
        ListTag list;
        if (nbt instanceof NumericTag) {
            NumericTag numeric = (NumericTag)nbt;
            return numeric.m_7053_();
        }
        if (nbt instanceof ListTag && (list = (ListTag)nbt).size() == 1) {
            return this.readNumberNbt(list.get(0));
        }
        if (nbt instanceof StringTag) {
            StringTag string = (StringTag)nbt;
            return ShortAdapter.parse(string.m_7916_()).map(Number::shortValue).orElse(null);
        }
        return null;
    }

    @Override
    protected JsonElement writeNumberJson(Short value) {
        return new JsonPrimitive((Number)value);
    }

    @Override
    @Nullable
    protected Short readNumberJson(JsonElement json) {
        JsonArray array;
        if (json instanceof JsonObject) {
            return null;
        }
        if (json instanceof JsonArray && (array = (JsonArray)json).size() == 1) {
            return this.readNumberJson(array.get(0));
        }
        if (json instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)json;
            if (primitive.isNumber()) {
                return primitive.getAsShort();
            }
            if (primitive.isString()) {
                return ShortAdapter.parse(primitive.getAsString()).map(Number::shortValue).orElse(null);
            }
        }
        return null;
    }
}

