/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.ISimpleAdapter;
import iskallia.vault.core.net.BitBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class BlockPosAdapter
implements ISimpleAdapter<BlockPos, Tag, JsonElement> {
    private final boolean nullable;

    public BlockPosAdapter(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public BlockPosAdapter asNullable() {
        return new BlockPosAdapter(true);
    }

    @Override
    public void writeBits(@Nullable BlockPos value, BitBuffer buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            buffer.writeLong(value.m_121878_());
        }
    }

    @Override
    public Optional<BlockPos> readBits(BitBuffer buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(BlockPos.m_122022_((long)buffer.readLong()));
    }

    @Override
    public void writeBytes(@Nullable BlockPos value, ByteBuf buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            buffer.writeLong(value.m_121878_());
        }
    }

    @Override
    public Optional<BlockPos> readBytes(ByteBuf buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(BlockPos.m_122022_((long)buffer.readLong()));
    }

    @Override
    public void writeData(@Nullable BlockPos value, DataOutput data) throws IOException {
        if (this.nullable) {
            data.writeBoolean(value == null);
        }
        if (value != null) {
            data.writeLong(value.m_121878_());
        }
    }

    @Override
    public Optional<BlockPos> readData(DataInput data) throws IOException {
        if (this.nullable && data.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(BlockPos.m_122022_((long)data.readLong()));
    }

    @Override
    public Optional<Tag> writeNbt(@Nullable BlockPos value) {
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(LongTag.m_128882_((long)value.m_121878_()));
    }

    @Override
    public Optional<BlockPos> readNbt(@Nullable Tag nbt) {
        CollectionTag list;
        if (nbt == null) {
            return Optional.empty();
        }
        if (nbt instanceof NumericTag) {
            NumericTag numeric = (NumericTag)nbt;
            return Adapters.LONG.readNbt((Tag)numeric).map(BlockPos::m_122022_);
        }
        if (nbt instanceof CollectionTag && (list = (CollectionTag)nbt).size() == 3) {
            Integer x = Adapters.INT.readNbt((Tag)list.get(0)).orElse(null);
            Integer y = Adapters.INT.readNbt((Tag)list.get(1)).orElse(null);
            Integer z = Adapters.INT.readNbt((Tag)list.get(2)).orElse(null);
            if (x != null && y != null && z != null) {
                return Optional.of(new BlockPos(x.intValue(), y.intValue(), z.intValue()));
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<JsonElement> writeJson(@Nullable BlockPos value) {
        return value == null ? Optional.empty() : Optional.of(new JsonPrimitive((Number)value.m_121878_()));
    }

    @Override
    public Optional<BlockPos> readJson(@Nullable JsonElement json) {
        JsonArray array;
        if (json == null) {
            return Optional.empty();
        }
        if (json instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)json;
            return Adapters.LONG.readJson((JsonElement)primitive).map(BlockPos::m_122022_);
        }
        if (json instanceof JsonArray && (array = (JsonArray)json).size() == 3) {
            Integer x = Adapters.INT.readJson(array.get(0)).orElse(null);
            Integer y = Adapters.INT.readJson(array.get(1)).orElse(null);
            Integer z = Adapters.INT.readJson(array.get(2)).orElse(null);
            if (x != null && y != null && z != null) {
                return Optional.of(new BlockPos(x.intValue(), y.intValue(), z.intValue()));
            }
        }
        return Optional.empty();
    }
}

