/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.util;

import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.ISimpleAdapter;
import iskallia.vault.core.net.BitBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;

public class ComponentAdapter
implements ISimpleAdapter<Component, Tag, JsonElement> {
    private final boolean nullable;

    public ComponentAdapter(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public ComponentAdapter asNullable() {
        return new ComponentAdapter(this.nullable);
    }

    @Override
    public void writeBits(@Nullable Component value, BitBuffer buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            Adapters.UTF_8.writeBits(Component.Serializer.m_130703_((Component)value), buffer);
        }
    }

    @Override
    public Optional<Component> readBits(BitBuffer buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Adapters.UTF_8.readBits(buffer).map(Component.Serializer::m_130701_);
    }

    @Override
    public void writeBytes(@Nullable Component value, ByteBuf buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            Adapters.UTF_8.writeBytes(Component.Serializer.m_130703_((Component)value), buffer);
        }
    }

    @Override
    public Optional<Component> readBytes(ByteBuf buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Adapters.UTF_8.readBytes(buffer).map(Component.Serializer::m_130701_);
    }

    @Override
    public void writeData(@Nullable Component value, DataOutput data) throws IOException {
        if (this.nullable) {
            data.writeBoolean(value == null);
        }
        if (value != null) {
            Adapters.UTF_8.writeData(Component.Serializer.m_130703_((Component)value), data);
        }
    }

    @Override
    public Optional<Component> readData(DataInput data) throws IOException {
        if (this.nullable && data.readBoolean()) {
            return Optional.empty();
        }
        return Adapters.UTF_8.readData(data).map(Component.Serializer::m_130701_);
    }

    @Override
    public Optional<Tag> writeNbt(@Nullable Component value) {
        if (value == null) {
            return Optional.empty();
        }
        return Adapters.UTF_8.writeNbt(Component.Serializer.m_130703_((Component)value));
    }

    @Override
    public Optional<Component> readNbt(@Nullable Tag nbt) {
        if (nbt == null) {
            return Optional.empty();
        }
        return Adapters.UTF_8.readNbt(nbt).map(Component.Serializer::m_130701_);
    }

    @Override
    public Optional<JsonElement> writeJson(@Nullable Component value) {
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(Component.Serializer.m_130716_((Component)value));
    }

    @Override
    public Optional<Component> readJson(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return Optional.empty();
        }
        return Optional.ofNullable(Component.Serializer.m_130691_((JsonElement)json));
    }
}

