/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.ISimpleAdapter;
import iskallia.vault.core.net.BitBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class IdentifierAdapter
implements ISimpleAdapter<ResourceLocation, Tag, JsonElement> {
    private final boolean nullable;

    public IdentifierAdapter(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public IdentifierAdapter asNullable() {
        return new IdentifierAdapter(true);
    }

    @Override
    public void writeBits(@Nullable ResourceLocation value, BitBuffer buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            buffer.writeIdentifier(value);
        }
    }

    @Override
    public Optional<ResourceLocation> readBits(BitBuffer buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(buffer.readIdentifier());
    }

    @Override
    public void writeBytes(@Nullable ResourceLocation value, ByteBuf buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            String string = value.m_135827_().equals("minecraft") ? value.m_135815_() : value.toString();
            Adapters.UTF_8.writeBytes(string, buffer);
        }
    }

    @Override
    public Optional<ResourceLocation> readBytes(ByteBuf buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(new ResourceLocation(Adapters.UTF_8.readBytes(buffer).orElseThrow()));
    }

    @Override
    public void writeData(@Nullable ResourceLocation value, DataOutput data) throws IOException {
        if (this.nullable) {
            data.writeBoolean(value == null);
        }
        if (value != null) {
            String string = value.m_135827_().equals("minecraft") ? value.m_135815_() : value.toString();
            Adapters.UTF_8.writeData(string, data);
        }
    }

    @Override
    public Optional<ResourceLocation> readData(DataInput data) throws IOException {
        if (this.nullable && data.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(new ResourceLocation(Adapters.UTF_8.readData(data).orElseThrow()));
    }

    @Override
    public Optional<Tag> writeNbt(@Nullable ResourceLocation value) {
        if (value == null) {
            return Optional.empty();
        }
        String string = value.m_135827_().equals("minecraft") ? value.m_135815_() : value.toString();
        return Optional.of(StringTag.m_129297_((String)string));
    }

    @Override
    public Optional<ResourceLocation> readNbt(@Nullable Tag nbt) {
        CollectionTag array;
        CollectionTag array2;
        if (nbt instanceof StringTag) {
            StringTag string = (StringTag)nbt;
            return Optional.ofNullable(ResourceLocation.m_135820_((String)string.m_7916_()));
        }
        if (nbt instanceof CollectionTag && (array2 = (CollectionTag)nbt).size() == 1) {
            return this.readNbt((Tag)array2.get(0));
        }
        if (nbt instanceof CollectionTag && (array = (CollectionTag)nbt).size() == 2) {
            String namespace = Adapters.UTF_8.readNbt((Tag)array.get(0)).orElse(null);
            String path = Adapters.UTF_8.readNbt((Tag)array.get(1)).orElse(null);
            if (namespace == null || path == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(ResourceLocation.m_135820_((String)(namespace + ":" + path)));
        }
        return Optional.empty();
    }

    @Override
    public Optional<JsonElement> writeJson(@Nullable ResourceLocation value) {
        if (value == null) {
            return Optional.empty();
        }
        String string = value.m_135827_().equals("minecraft") ? value.m_135815_() : value.toString();
        return Optional.of(new JsonPrimitive(string));
    }

    @Override
    public Optional<ResourceLocation> readJson(@Nullable JsonElement json) {
        JsonArray array;
        JsonArray array2;
        JsonPrimitive primitive;
        if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString()) {
            return Optional.ofNullable(ResourceLocation.m_135820_((String)primitive.getAsString()));
        }
        if (json instanceof JsonArray && (array2 = (JsonArray)json).size() == 1) {
            return this.readJson(array2.get(0));
        }
        if (json instanceof JsonArray && (array = (JsonArray)json).size() == 2) {
            String namespace = Adapters.UTF_8.readJson(array.get(0)).orElse(null);
            String path = Adapters.UTF_8.readJson(array.get(1)).orElse(null);
            if (namespace == null || path == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(ResourceLocation.m_135820_((String)(namespace + ":" + path)));
        }
        return Optional.empty();
    }
}

