/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.ISimpleAdapter;
import iskallia.vault.core.net.BitBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class ItemStackAdapter
implements ISimpleAdapter<ItemStack, Tag, JsonElement> {
    private final boolean nullable;

    public ItemStackAdapter(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public ItemStackAdapter asNullable() {
        return new ItemStackAdapter(true);
    }

    @Override
    public void writeBits(@Nullable ItemStack value, BitBuffer buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            buffer.writeBoolean(value.m_41619_());
            if (value.m_41619_()) {
                return;
            }
            Adapters.ITEM.writeBits(value.m_41720_(), buffer);
            Adapters.INT_SEGMENTED_7.writeBits(value.m_41613_(), buffer);
            Adapters.COMPOUND_NBT.asNullable().writeBits(value.m_41783_(), buffer);
            CompoundTag caps = value.serializeNBT().m_128469_("ForgeCaps");
            Adapters.COMPOUND_NBT.asNullable().writeBits(caps.m_128456_() ? null : caps, buffer);
        }
    }

    @Override
    public Optional<ItemStack> readBits(BitBuffer buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        if (buffer.readBoolean()) {
            return Optional.of(ItemStack.f_41583_);
        }
        Item item = Adapters.ITEM.readBits(buffer).orElse(Items.f_41852_);
        int count = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
        CompoundTag tag = Adapters.COMPOUND_NBT.asNullable().readBits(buffer).orElse(null);
        CompoundTag caps = Adapters.COMPOUND_NBT.asNullable().readBits(buffer).orElse(null);
        ItemStack stack = new ItemStack((ItemLike)item, count, caps);
        stack.m_41751_(tag);
        return Optional.of(stack);
    }

    @Override
    public void writeBytes(@Nullable ItemStack value, ByteBuf buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            buffer.writeBoolean(value.m_41619_());
            if (value.m_41619_()) {
                return;
            }
            Adapters.ITEM.writeBytes(value.m_41720_(), buffer);
            Adapters.INT_SEGMENTED_7.writeBytes(value.m_41613_(), buffer);
            Adapters.COMPOUND_NBT.asNullable().writeBytes(value.m_41783_(), buffer);
            CompoundTag caps = value.serializeNBT().m_128469_("ForgeCaps");
            Adapters.COMPOUND_NBT.asNullable().writeBytes(caps.m_128456_() ? null : caps, buffer);
        }
    }

    @Override
    public Optional<ItemStack> readBytes(ByteBuf buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        if (buffer.readBoolean()) {
            return Optional.of(ItemStack.f_41583_);
        }
        Item item = Adapters.ITEM.readBytes(buffer).orElse(Items.f_41852_);
        int count = (Integer)Adapters.INT_SEGMENTED_7.readBytes(buffer).orElseThrow();
        CompoundTag tag = Adapters.COMPOUND_NBT.asNullable().readBytes(buffer).orElse(null);
        CompoundTag caps = Adapters.COMPOUND_NBT.asNullable().readBytes(buffer).orElse(null);
        ItemStack stack = new ItemStack((ItemLike)item, count, caps);
        stack.m_41751_(tag);
        return Optional.of(stack);
    }

    @Override
    public void writeData(@Nullable ItemStack value, DataOutput data) throws IOException {
        if (this.nullable) {
            data.writeBoolean(value == null);
        }
        if (value != null) {
            data.writeBoolean(value.m_41619_());
            if (value.m_41619_()) {
                return;
            }
            Adapters.ITEM.writeData(value.m_41720_(), data);
            Adapters.INT_SEGMENTED_7.writeData(value.m_41613_(), data);
            Adapters.COMPOUND_NBT.asNullable().writeData(value.m_41783_(), data);
            CompoundTag caps = value.serializeNBT().m_128469_("ForgeCaps");
            Adapters.COMPOUND_NBT.asNullable().writeData(caps.m_128456_() ? null : caps, data);
        }
    }

    @Override
    public Optional<ItemStack> readData(DataInput data) throws IOException {
        if (this.nullable && data.readBoolean()) {
            return Optional.empty();
        }
        if (data.readBoolean()) {
            return Optional.of(ItemStack.f_41583_);
        }
        Item item = Adapters.ITEM.readData(data).orElse(Items.f_41852_);
        int count = (Integer)Adapters.INT_SEGMENTED_7.readData(data).orElseThrow();
        CompoundTag tag = Adapters.COMPOUND_NBT.asNullable().readData(data).orElse(null);
        CompoundTag caps = Adapters.COMPOUND_NBT.asNullable().readData(data).orElse(null);
        ItemStack stack = new ItemStack((ItemLike)item, count, caps);
        stack.m_41751_(tag);
        return Optional.of(stack);
    }

    @Override
    public Optional<Tag> writeNbt(@Nullable ItemStack value) {
        return value == null ? Optional.empty() : Optional.of(value.serializeNBT());
    }

    @Override
    public Optional<ItemStack> readNbt(@Nullable Tag nbt) {
        Optional<ItemStack> optional;
        if (nbt instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)nbt;
            optional = Optional.of(ItemStack.m_41712_((CompoundTag)compound));
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    public Optional<JsonElement> writeJson(@Nullable ItemStack value) {
        if (value == null) {
            return Optional.empty();
        }
        JsonObject json = new JsonObject();
        Adapters.ITEM.writeJson(value.m_41720_()).ifPresent(element -> json.add("id", element));
        Adapters.COMPOUND_NBT.writeJson(value.m_41783_()).ifPresent(element -> json.add("nbt", element));
        Adapters.INT.writeJson(value.m_41613_()).ifPresent(element -> json.add("count", element));
        return Optional.of(json);
    }

    @Override
    public Optional<ItemStack> readJson(@Nullable JsonElement json) {
        JsonPrimitive primitive;
        if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString()) {
            return Adapters.ITEM.readJson((JsonElement)primitive).map(ItemStack::new);
        }
        if (json instanceof JsonObject) {
            JsonObject object = (JsonObject)json;
            ItemStack stack = new ItemStack((ItemLike)Adapters.ITEM.readJson(object.get("id")).orElse(Items.f_41852_), Adapters.INT.readJson(object.get("count")).orElse(1).intValue());
            if (object.has("nbt")) {
                stack.m_41751_((CompoundTag)Adapters.COMPOUND_NBT.readJson(object.get("nbt")).orElse(null));
            }
            return Optional.of(stack);
        }
        return Optional.empty();
    }
}

