/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.vault;

import iskallia.vault.core.data.adapter.IBitAdapter;
import iskallia.vault.core.data.key.VersionedKey;
import iskallia.vault.core.data.key.registry.KeyRegistry;
import iskallia.vault.core.data.sync.context.SyncContext;
import iskallia.vault.core.net.BitBuffer;
import java.util.Optional;
import java.util.function.Supplier;

public class RegistryKeyAdapter<K extends VersionedKey<? extends K, ? extends V>, V>
implements IBitAdapter<K, SyncContext> {
    private final Supplier<KeyRegistry<K, V>> registry;
    private final boolean nullable;

    public RegistryKeyAdapter(Supplier<KeyRegistry<K, V>> registry, boolean nullable) {
        this.registry = registry;
        this.nullable = nullable;
    }

    public static <K extends VersionedKey<? extends K, ? extends V>, V> RegistryKeyAdapter<K, V> of(Supplier<KeyRegistry<K, V>> registry) {
        return new RegistryKeyAdapter<K, V>(registry, false);
    }

    public RegistryKeyAdapter<K, V> asNullable() {
        return new RegistryKeyAdapter<K, V>(this.registry, true);
    }

    @Override
    public void writeBits(K value, BitBuffer buffer, SyncContext context) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            buffer.writeIdentifier(((VersionedKey)value).getId());
        }
    }

    @Override
    public Optional<K> readBits(BitBuffer buffer, SyncContext context) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.registry.get().getKey(buffer.readIdentifier()));
    }
}

