/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.event.common;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.Event;
import iskallia.vault.core.event.common.ObjectiveTemplates;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.CrakePedestalObjective;
import iskallia.vault.core.vault.objective.GreedPillarObjective;
import iskallia.vault.core.vault.objective.GridGatewayObjective;
import iskallia.vault.core.vault.objective.HeraldObjective;
import iskallia.vault.core.vault.objective.LegacyObeliskObjective;
import iskallia.vault.core.vault.objective.LodestoneObjective;
import iskallia.vault.core.vault.objective.MonolithObjective;
import iskallia.vault.core.vault.objective.ObeliskObjective;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.objective.RuneBossObjective;
import iskallia.vault.core.vault.objective.ScavengerObjective;
import iskallia.vault.core.world.template.EmptyTemplate;
import iskallia.vault.core.world.template.JigsawTemplate;
import iskallia.vault.core.world.template.Template;
import java.util.function.BiFunction;

public class ObjectiveTemplateEvent
extends Event<ObjectiveTemplateEvent, Data> {
    private static final ObjectiveTemplateEvent INSTANCE = new ObjectiveTemplateEvent();

    public static ObjectiveTemplateEvent getInstance() {
        return INSTANCE;
    }

    protected ObjectiveTemplateEvent() {
    }

    protected ObjectiveTemplateEvent(ObjectiveTemplateEvent parent) {
        super(parent);
    }

    @Override
    public ObjectiveTemplateEvent createChild() {
        return new ObjectiveTemplateEvent(this);
    }

    public void registerObjectiveTemplate(Objective objective, Vault vault, Template newTemplate) {
        this.registerObjectiveTemplate(objective, vault, (Vault v, RandomSource r) -> newTemplate != null ? newTemplate : EmptyTemplate.INSTANCE);
    }

    public void registerObjectiveTemplate(Objective objective, Vault vault, BiFunction<Vault, RandomSource, Template> newTemplateProvider) {
        this.register(objective, data -> {
            if (data.getVault() != vault) {
                return;
            }
            JigsawTemplate template = data.getTemplate();
            if (template != null) {
                template.setRoot((Template)newTemplateProvider.apply(vault, data.getRandom()));
            }
        });
    }

    public Template getTemplateForObjective(Objective objective) {
        if (objective instanceof ScavengerObjective) {
            return ObjectiveTemplates.SCAVENGER_OBJECTIVE_TEMPLATE;
        }
        if (objective instanceof MonolithObjective) {
            return ObjectiveTemplates.MONOLITH_OBJECTIVE_TEMPLATE;
        }
        if (objective instanceof ObeliskObjective || objective instanceof LegacyObeliskObjective) {
            return ObjectiveTemplates.OBELISK_OBJECTIVE_TEMPLATE;
        }
        if (objective instanceof CrakePedestalObjective) {
            return ObjectiveTemplates.CRAKE_OBJECTIVE_TEMPLATE;
        }
        if (objective instanceof LodestoneObjective) {
            return ObjectiveTemplates.LODESTONE_OBJECTIVE_TEMPLATE;
        }
        if (objective instanceof GridGatewayObjective) {
            return ObjectiveTemplates.GRID_GATEWAY_OBJECTIVE_TEMPLATE;
        }
        if (objective instanceof RuneBossObjective) {
            return ObjectiveTemplates.RUNE_BOSS_OBJECTIVE_TEMPLATE;
        }
        if (objective instanceof HeraldObjective) {
            return ObjectiveTemplates.HERALD_OBJECTIVE_TEMPLATE;
        }
        if (objective instanceof GreedPillarObjective) {
            return ObjectiveTemplates.GREED_PILLAR_OBJECTIVE_TEMPLATE;
        }
        return null;
    }

    static {
        CommonEvents.REGISTRY.add(INSTANCE);
    }

    public static class Data {
        private JigsawTemplate template;
        private final Vault vault;
        private final RandomSource random;

        public Data(JigsawTemplate template, Vault vault, RandomSource random) {
            this.template = template;
            this.vault = vault;
            this.random = random;
        }

        public JigsawTemplate getTemplate() {
            return this.template;
        }

        public void setTemplate(JigsawTemplate template) {
            this.template = template;
        }

        public Vault getVault() {
            return this.vault;
        }

        public RandomSource getRandom() {
            return this.random;
        }
    }
}

