/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.random;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.random.lcg.Lcg;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class LCGRandom
implements RandomSource {
    protected Lcg lcg;
    protected long seed;

    protected LCGRandom(Lcg lcg, long seed) {
        this.lcg = lcg;
        this.seed = seed;
    }

    public static LCGRandom of(Lcg lcg, long seed) {
        return new LCGRandom(lcg, seed);
    }

    public Lcg getLCG() {
        return this.lcg;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public long nextSeed() {
        this.seed = this.lcg.nextSeed(this.seed);
        return this.seed;
    }

    @Override
    public long nextLong() {
        return this.nextSeed();
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        Adapters.LCG.writeBits(this.lcg, buffer);
        if (this.lcg.modulus == 0L) {
            Adapters.LONG.writeBits(this.seed, buffer);
        } else {
            Adapters.ofBoundedLong(this.lcg.modulus).writeBits(this.seed, buffer);
        }
    }

    @Override
    public void readBits(BitBuffer buffer) {
        this.lcg = Adapters.LCG.readBits(buffer).orElseThrow();
        this.seed = this.lcg.modulus == 0L ? ((Long)Adapters.LONG.readBits(buffer).orElseThrow()).longValue() : ((Long)Adapters.ofBoundedLong(this.lcg.modulus).readBits(buffer).orElseThrow()).longValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        Adapters.LCG.writeNbt(this.lcg).ifPresent(value -> nbt.m_128365_("lcg", (Tag)value));
        Adapters.LONG.writeNbt(this.seed).ifPresent(value -> nbt.m_128365_("seed", value));
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        this.lcg = (Lcg)Adapters.LCG.readNbt((CompoundTag)nbt.m_128423_("lcg")).orElseThrow();
        this.seed = (Long)Adapters.LONG.readNbt(nbt.m_128423_("seed")).orElseThrow();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        JsonObject json = new JsonObject();
        Adapters.LCG.writeJson(this.lcg).ifPresent(value -> json.add("lcg", (JsonElement)value));
        Adapters.LONG.writeJson(this.seed).ifPresent(value -> json.add("seed", value));
        return Optional.of(json);
    }

    @Override
    public void readJson(JsonObject json) {
        this.lcg = (Lcg)Adapters.LCG.readJson((JsonObject)json.get("lcg")).orElseThrow();
        this.seed = (Long)Adapters.LONG.readJson(json.get("seed")).orElseThrow();
    }
}

