/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.util;

import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.WeightedList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class FastWeightedList<T> {
    private double totalWeight = 0.0;
    private double[] weights;
    private List<T> values;

    public FastWeightedList(WeightedList<T> original) {
        int size = original.size();
        this.weights = new double[size];
        this.values = new ArrayList<T>(size);
        int index = 0;
        for (Map.Entry<T, Double> entry : original.entrySet()) {
            double weight = Math.max(entry.getValue(), 0.0);
            this.totalWeight += weight;
            this.weights[index] = weight;
            this.values.add(entry.getKey());
            ++index;
        }
    }

    public Optional<T> getRandom(RandomSource random) {
        if (this.totalWeight <= 0.0) {
            return Optional.empty();
        }
        double target = random.nextDouble() * this.totalWeight;
        for (int i = 0; i < this.weights.length; ++i) {
            if (target < this.weights[i]) {
                return Optional.ofNullable(this.values.get(i));
            }
            target -= this.weights[i];
        }
        return Optional.empty();
    }
}

