/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.util;

import iskallia.vault.core.util.RotateMirror;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;

public final class RotNorm {
    private final int rotation;
    private final int invertedNormal;

    private RotNorm(int rotation, int invertedNormal) {
        this.rotation = rotation & 3;
        this.invertedNormal = invertedNormal & 1;
    }

    public RotNorm plus(RotNorm o) {
        int r = this.rotation + o.rotation;
        if (this.invertedNormal == 0 && (this.rotation & 1) == 1 && o.invertedNormal == 1) {
            r += 2;
        }
        return new RotNorm(r, this.invertedNormal + o.invertedNormal);
    }

    public static RotNorm from(RotateMirror rm) {
        Mirror m = rm.mirror();
        Rotation r = rm.rotation();
        return switch (m) {
            default -> throw new IncompatibleClassChangeError();
            case Mirror.NONE -> {
                switch (r) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case NONE: {
                        yield new RotNorm(0, 0);
                    }
                    case CLOCKWISE_90: {
                        yield new RotNorm(1, 0);
                    }
                    case CLOCKWISE_180: {
                        yield new RotNorm(2, 0);
                    }
                    case COUNTERCLOCKWISE_90: 
                }
                yield new RotNorm(3, 0);
            }
            case Mirror.FRONT_BACK -> {
                switch (r) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case NONE: {
                        yield new RotNorm(2, 1);
                    }
                    case CLOCKWISE_90: {
                        yield new RotNorm(1, 1);
                    }
                    case CLOCKWISE_180: {
                        yield new RotNorm(0, 1);
                    }
                    case COUNTERCLOCKWISE_90: 
                }
                yield new RotNorm(3, 1);
            }
            case Mirror.LEFT_RIGHT -> {
                switch (r) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case NONE: {
                        yield new RotNorm(0, 1);
                    }
                    case CLOCKWISE_90: {
                        yield new RotNorm(3, 1);
                    }
                    case CLOCKWISE_180: {
                        yield new RotNorm(2, 1);
                    }
                    case COUNTERCLOCKWISE_90: 
                }
                yield new RotNorm(1, 1);
            }
        };
    }

    public RotateMirror toRotateMirror() {
        Rotation r = switch (this.rotation) {
            case 0 -> Rotation.NONE;
            case 1 -> Rotation.CLOCKWISE_90;
            case 2 -> Rotation.CLOCKWISE_180;
            case 3 -> Rotation.COUNTERCLOCKWISE_90;
            default -> throw new IllegalStateException();
        };
        Mirror m = this.invertedNormal == 0 ? Mirror.NONE : ((this.rotation & 1) == 0 ? Mirror.LEFT_RIGHT : Mirror.FRONT_BACK);
        return new RotateMirror(r, m);
    }
}

