/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.util;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.key.ThemeKey;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.generator.theme.ClassicVaultTheme;
import iskallia.vault.core.world.generator.theme.Theme;
import iskallia.vault.core.world.processor.Palette;
import iskallia.vault.core.world.processor.tile.WeightedTileProcessor;
import iskallia.vault.core.world.template.data.TemplatePool;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.world.data.VoidStoneBlacklistData;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;

public class ThemeBlockRetriever {
    public static final Map<ResourceLocation, List<ResourceLocation>> CACHE = new ConcurrentHashMap<ResourceLocation, List<ResourceLocation>>();

    public static List<ResourceLocation> getBlocksForTheme(ResourceLocation themeId) {
        return CACHE.computeIfAbsent(themeId, ThemeBlockRetriever::buildBlocksForTheme);
    }

    private static List<ResourceLocation> buildBlocksForTheme(ResourceLocation themeId) {
        if (CACHE.containsKey(themeId)) {
            return CACHE.get(themeId);
        }
        ThemeKey themeKey = VaultRegistry.THEME.getKey(themeId);
        Theme theme = (Theme)themeKey.get(Version.latest());
        if (!(theme instanceof ClassicVaultTheme)) {
            return List.of();
        }
        ClassicVaultTheme classicVaultTheme = (ClassicVaultTheme)theme;
        LinkedHashSet<ResourceLocation> blocks = new LinkedHashSet<ResourceLocation>();
        TemplatePool starts = (TemplatePool)classicVaultTheme.getStarts().get(Version.latest());
        TemplatePool rooms = (TemplatePool)classicVaultTheme.getRooms().get(Version.latest());
        TemplatePool tunnels = (TemplatePool)classicVaultTheme.getTunnels().get(Version.latest());
        if (starts != null) {
            ThemeBlockRetriever.generateRooms(starts, blocks);
        }
        if (rooms != null) {
            ThemeBlockRetriever.generateRooms(rooms, blocks);
        }
        if (tunnels != null) {
            ThemeBlockRetriever.generateRooms(tunnels, blocks);
        }
        return List.copyOf(blocks);
    }

    public static boolean allowVaultBlock(@Nullable ResourceLocation regName) {
        if (regName == null) {
            return true;
        }
        if (!regName.m_135827_().equals("the_vault")) {
            return true;
        }
        String name = regName.toString();
        return name.contains("velara") || name.contains("tenos") || name.contains("wendarr") || name.contains("idona") || ModConfigs.VOID_CRUCIBLE.getAllowedBlocks().contains(regName);
    }

    private static void generateRooms(TemplatePool rooms, Set<ResourceLocation> blocks) {
        ArrayList palettes = new ArrayList();
        rooms.iterate(template -> {
            template.getPalettes().forEach(palettes::add);
            return true;
        });
        if (palettes.isEmpty()) {
            return;
        }
        palettes.forEach(paletteKey -> {
            Palette palette = (Palette)paletteKey.get(Version.latest());
            palette.getTileProcessors().forEach(tileProcessor -> {
                if (tileProcessor instanceof WeightedTileProcessor) {
                    WeightedTileProcessor weightedTileProcessor = (WeightedTileProcessor)tileProcessor;
                    WeightedList<PartialTile> partialTileWeightedList = weightedTileProcessor.getOutput();
                    partialTileWeightedList.forEach((tile, weight) -> tile.getState().getBlock().asWhole().ifPresent(block -> {
                        if (block.m_49966_().m_60795_()) {
                            return;
                        }
                        if (block.m_5456_().getCreativeTabs().isEmpty()) {
                            return;
                        }
                        if (blocks.contains(block.getRegistryName())) {
                            return;
                        }
                        if (block instanceof LightBlock) {
                            return;
                        }
                        if (block.getRegistryName() != null && !ThemeBlockRetriever.allowVaultBlock(block.getRegistryName())) {
                            return;
                        }
                        blocks.add(block.getRegistryName());
                    }));
                }
            });
        });
    }

    public static boolean shouldVoidItem(ServerPlayer player, ItemEntity itemEntity, ServerLevel world, ResourceLocation theme) {
        if (itemEntity == null || itemEntity.m_32055_().m_41619_()) {
            return false;
        }
        if (theme == null || theme.toString().isEmpty()) {
            return false;
        }
        ItemStack stack = itemEntity.m_32055_();
        if (stack.m_41619_() || stack.m_41720_().getRegistryName() == null) {
            return false;
        }
        VoidStoneBlacklistData data = VoidStoneBlacklistData.get(world);
        List<ResourceLocation> blacklist = data.getInventory(player).getBlacklist();
        ResourceLocation itemId = stack.m_41720_().getRegistryName();
        if (itemId != null) {
            BlockItem blockItem;
            if (blacklist.contains(itemId)) {
                return false;
            }
            Item item = stack.m_41720_();
            if (item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof AnvilBlock && blacklist.contains(Blocks.f_50322_.getRegistryName())) {
                return false;
            }
        }
        if (!ThemeBlockRetriever.allowVaultBlock(stack.m_41720_().getRegistryName())) {
            return false;
        }
        List<ResourceLocation> themes = ThemeBlockRetriever.getBlocksForTheme(theme);
        List<ResourceLocation> specialRooms = ModConfigs.VOID_CRUCIBLE_CUSTOM_ROOMS.getAllItems();
        return themes.contains(stack.m_41720_().getRegistryName()) || specialRooms.contains(stack.m_41720_().getRegistryName());
    }
}

