/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.util;

import iskallia.vault.core.random.RandomSource;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.DoubleUnaryOperator;
import java.util.random.RandomGenerator;
import org.jetbrains.annotations.NotNull;

public class WeightedList<T>
extends AbstractMap<T, Double> {
    private static final WeightedList<?> EMPTY = new WeightedList();
    private final Map<T, Double> delegate = new LinkedHashMap<T, Double>();

    public static <T> T empty() {
        return (T)EMPTY;
    }

    @Override
    @NotNull
    public Set<Map.Entry<T, Double>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public Double put(T value, Double weight) {
        return this.delegate.put(value, weight);
    }

    @Override
    public Double put(T value, Number weight) {
        return this.put(value, weight.doubleValue());
    }

    public WeightedList<T> add(T value, Double weight) {
        double current = this.getOrDefault(value, 0.0);
        this.put(value, current + weight);
        return this;
    }

    public WeightedList<T> add(T value, Number weight) {
        return this.add(value, weight.doubleValue());
    }

    public double getTotalWeight() {
        double sum = 0.0;
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            double weight = (Double)iterator.next();
            sum += Math.max(weight, 0.0);
        }
        return sum;
    }

    public Optional<T> getRandom() {
        return this.getRandom(new Random());
    }

    public Optional<T> getRandom(RandomGenerator random) {
        return this.getRandom(random::nextDouble);
    }

    public Optional<T> getRandom(RandomSource random) {
        return this.getRandom(random::nextDouble);
    }

    public Optional<T> getRandom(DoubleUnaryOperator random) {
        double total = this.getTotalWeight();
        if (total <= 0.0) {
            return Optional.empty();
        }
        double index = random.applyAsDouble(total);
        for (Map.Entry<T, Double> entry : this.delegate.entrySet()) {
            T value = entry.getKey();
            double weight = Math.max(entry.getValue(), 0.0);
            if (index < weight) {
                return Optional.ofNullable(value);
            }
            index -= weight;
        }
        return Optional.empty();
    }

    public List<T> getNRandom(int amount, RandomSource random) {
        ArrayList<T> randomValues = new ArrayList<T>();
        WeightedList<T> copy = new WeightedList<T>();
        copy.putAll(this);
        while (randomValues.size() < amount) {
            Optional<T> randomValue = copy.getRandom(random);
            if (!randomValue.isPresent()) continue;
            randomValues.add(randomValue.get());
            copy.remove(randomValue.get());
            if (!copy.isEmpty() || randomValues.size() >= amount) continue;
            copy.putAll(this);
        }
        return randomValues;
    }

    public boolean contains(T item) {
        return this.delegate.containsKey(item);
    }
}

