/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault;

import iskallia.vault.antique.AntiqueRegistry;
import iskallia.vault.antique.condition.DropConditionContext;
import iskallia.vault.antique.condition.DropConditionContextFactory;
import iskallia.vault.block.CoinPileBlock;
import iskallia.vault.block.VaultChestBlock;
import iskallia.vault.block.entity.base.TemplateTagContainer;
import iskallia.vault.config.ShopPedestalConfig;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.ChestGenerationEvent;
import iskallia.vault.core.event.common.CoinStacksGenerationEvent;
import iskallia.vault.core.event.common.LootableBlockGenerationEvent;
import iskallia.vault.core.event.common.OreLootGenerationEvent;
import iskallia.vault.core.event.common.ShopPedestalGenerationEvent;
import iskallia.vault.core.event.common.VaultRoyaleCrateGenerationEvent;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.LootLogic;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultLevel;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.vault.objective.ArchitectObjective;
import iskallia.vault.core.vault.stat.ChestStat;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.vault.stat.VaultChestType;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.item.AntiqueItem;
import iskallia.vault.item.CompanionItem;
import iskallia.vault.item.CompanionParticleTrailItem;
import iskallia.vault.item.CompanionRelicItem;
import iskallia.vault.network.message.TrappedMobChestParticlesMessage;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.VaultRarity;
import iskallia.vault.util.calc.TrapDisarmChanceHelper;
import iskallia.vault.world.vault.chest.MobTrapEffect;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class ClassicLootLogic
extends LootLogic {
    public static final SupplierKey<LootLogic> KEY = (SupplierKey)SupplierKey.of("classic", LootLogic.class).with(Version.v1_0, (LootLogic)((Object)((Supplier<LootLogic>)ClassicLootLogic::new)));
    public static final FieldRegistry FIELDS = LootLogic.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<Void> ADD_CATALYST_FRAGMENTS = (FieldKey)FieldKey.of("add_catalyst_fragments", Void.class).with(Version.v1_0, Adapters.ofVoid(), DISK.all()).register(FIELDS);

    @Override
    public SupplierKey<LootLogic> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    protected void onChestPreGenerate(VirtualWorld world, Vault vault, ChestGenerationEvent.Data data) {
        if (this.applyTrap(world, vault, data)) {
            data.setLootTable(null);
            world.m_7731_(data.getPos(), Blocks.f_50016_.m_49966_(), 3);
        }
    }

    @Override
    protected void onChestPostGenerate(VirtualWorld world, Vault vault, ChestGenerationEvent.Data data) {
        this.generateCatalystFragments(data, vault);
        this.generateRelicFragments(data, vault);
        this.generateAntiques(data.getLoot(), (BlockEntity)data.getTileEntity(), vault, data.getPlayer());
        this.initializeLoot(vault, data.getLoot(), data.getPos(), data.getRandom());
        this.triggerLootAttributes((BlockEntity)data.getTileEntity(), data.getRandom(), data.getPlayer());
    }

    @Override
    protected void onRoyaleCratePreGenerate(VirtualWorld world, Vault vault, VaultRoyaleCrateGenerationEvent.Data data) {
    }

    @Override
    protected void onRoyaleCratePostGenerate(VirtualWorld world, Vault vault, VaultRoyaleCrateGenerationEvent.Data data) {
        this.initializeLoot(vault, data.getLoot(), data.getPos(), data.getRandom());
        this.triggerLootAttributes((BlockEntity)data.getTileEntity(), data.getRandom(), data.getPlayer());
    }

    @Override
    protected void onBlockPreGenerate(VirtualWorld world, Vault vault, LootableBlockGenerationEvent.Data data) {
    }

    @Override
    protected void onBlockPostGenerate(VirtualWorld world, Vault vault, LootableBlockGenerationEvent.Data data) {
        this.initializeLoot(vault, data.getLoot(), data.getPos(), data.getRandom());
        this.triggerLootAttributes(data.getTileEntity(), data.getRandom(), data.getPlayer());
        this.generateRelicFragmentsTreasureSand(data, vault);
    }

    @Override
    protected void onShopPedestalGenerate(VirtualWorld world, Vault vault, ShopPedestalGenerationEvent.Data data) {
        int level = vault.getOptional(Vault.LEVEL).map(VaultLevel::get).orElse(0);
        ShopPedestalConfig.ShopOffer offer = ModConfigs.SHOP_PEDESTAL.getForLevel(level, data.getRandom());
        if (offer != null && !offer.isEmpty()) {
            ItemStack stack = this.initializeLoot(vault, offer.offer().m_41777_(), data.getPos(), data.getRandom());
            data.getTileEntity().setOffer(stack, OverSizedItemStack.of(offer.currency().overSizedStack()));
        }
        data.getTileEntity().setInitialized(true);
        data.getTileEntity().m_6596_();
        world.m_7260_(data.getPos(), data.getState(), data.getState(), 3);
    }

    @Override
    protected void onCoinPilePostGenerate(VirtualWorld world, Vault vault, CoinStacksGenerationEvent.Data data) {
        int size;
        BlockState state = data.getState();
        if (state.m_60713_((Block)ModBlocks.COIN_PILE) && (size = ((Integer)state.m_61143_((Property)CoinPileBlock.SIZE)).intValue()) == 1) {
            this.generateAntiques(data.getLoot(), data.getTileEntity(), vault, data.getPlayer());
        }
        this.initializeLoot(vault, data.getLoot(), data.getPos(), data.getRandom());
        this.triggerLootAttributes(data.getTileEntity(), data.getRandom(), data.getPlayer());
    }

    @Override
    protected void onOreLootPostGenerate(VirtualWorld world, Vault vault, OreLootGenerationEvent.Data data) {
        this.generateAntiques(data.getLoot(), data.getTileEntity(), vault, data.getPlayer());
        this.initializeLoot(vault, data.getLoot(), data.getPos(), data.getRandom());
    }

    protected boolean applyTrap(VirtualWorld world, Vault vault, ChestGenerationEvent.Data data) {
        VaultChestBlock chestBlock;
        boolean canBeTrapped;
        boolean bl = canBeTrapped = data.getState().m_60734_() instanceof VaultChestBlock && !VaultUtils.isHeraldVault(vault);
        if (!canBeTrapped) {
            return false;
        }
        Block block = data.getState().m_60734_();
        if (block instanceof VaultChestBlock && (chestBlock = (VaultChestBlock)block).getType().equals((Object)VaultChestType.TREASURE)) {
            return false;
        }
        WeightedList<String> pool = ModConfigs.VAULT_CHEST.getEffectPool(vault.get(Vault.LEVEL).get());
        if (pool == null) {
            return false;
        }
        double trapChance = ModConfigs.VAULT_CHEST.getTrapProbability(vault.get(Vault.LEVEL).get());
        trapChance = CommonEvents.CHEST_TRAP_GENERATION.invoke(data.getPlayer(), trapChance, pool).getProbability();
        float disarmChance = TrapDisarmChanceHelper.getTrapDisarmChance((LivingEntity)data.getPlayer());
        if (disarmChance >= 1.0f) {
            return false;
        }
        double effectiveTrapChance = trapChance * (double)(1.0f - disarmChance);
        double random = data.getRandom().nextDouble();
        if (trapChance <= 0.0 || random > effectiveTrapChance) {
            if (effectiveTrapChance < trapChance && random <= trapChance) {
                world.m_5594_(null, data.getPos(), ModSounds.DISARM_TRAP, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return false;
        }
        pool.getRandom(data.getRandom()).map(ModConfigs.VAULT_CHEST::getEffectByName).ifPresent(effect -> {
            if (effect instanceof MobTrapEffect) {
                world.m_5594_(null, data.getPos(), ModSounds.MOB_TRAP, SoundSource.BLOCKS, 1.0f, 1.0f);
                ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new TrappedMobChestParticlesMessage(data.getPos()));
            }
            effect.apply(world, vault, data.getPlayer());
        });
        vault.getOptional(Vault.STATS).map(c -> c.get(data.getPlayer().m_142081_())).ifPresent(stats -> stats.get(StatCollector.CHESTS).add(ChestStat.ofTrapped(((VaultChestBlock)data.getState().m_60734_()).getType())));
        return true;
    }

    protected void triggerLootAttributes(BlockEntity tile, RandomSource random, ServerPlayer player) {
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)player);
        ModGearAttributes.getLootTriggerAttributes().forEach(attr -> snapshot.getAttributeValueList(attr).forEach(modifier -> {
            if (modifier.shouldTrigger(tile)) {
                modifier.trigger(tile, random, player);
            }
        }));
    }

    protected <T extends BlockEntity> void generateAntiques(List<ItemStack> loot, BlockEntity tile, Vault vault, @Nullable ServerPlayer player) {
        if (!(tile instanceof TemplateTagContainer)) {
            return;
        }
        if (!vault.has(Vault.LEVEL)) {
            return;
        }
        int level = vault.get(Vault.LEVEL).get();
        DropConditionContext ctx = DropConditionContextFactory.makeLootableContext(level, tile, player);
        AntiqueRegistry.getAntiquesMatchingCondition(ctx).forEach(antique -> loot.add(AntiqueItem.createStack(antique)));
    }

    protected void generateCatalystFragments(ChestGenerationEvent.Data data, Vault vault) {
        if (!this.has(ADD_CATALYST_FRAGMENTS)) {
            return;
        }
        if (!vault.get(Vault.OBJECTIVES).getAll(ArchitectObjective.class).isEmpty()) {
            this.remove(ADD_CATALYST_FRAGMENTS);
            return;
        }
        if (vault.has(Vault.LEVEL) && vault.get(Vault.LEVEL).get() < ModConfigs.VAULT_CHEST_META.getCatalystMinLevel()) {
            return;
        }
        double probability = ModConfigs.VAULT_CHEST_META.getCatalystChance(data.getState().m_60734_(), data.getRarity());
        probability = CommonEvents.CHEST_CATALYST_GENERATION.invoke(data.getPlayer(), probability).getProbability();
        if ((double)data.getRandom().nextFloat() < probability) {
            data.getLoot().add(new ItemStack((ItemLike)ModItems.VAULT_CATALYST_FRAGMENT));
        }
    }

    protected void generateRelicFragments(ChestGenerationEvent.Data data, Vault vault) {
        Optional<ItemStack> companionOpt = CompanionItem.getCompanion((LivingEntity)data.getPlayer());
        if (companionOpt.isEmpty()) {
            return;
        }
        if (CompanionItem.getCompanionHearts(companionOpt.get()) <= 0 || !CompanionItem.isActive(companionOpt.get())) {
            return;
        }
        if (vault.has(Vault.LEVEL) && vault.get(Vault.LEVEL).get() < ModConfigs.COMPANION_RELICS.getRelicMinLevel()) {
            return;
        }
        double probability = ModConfigs.COMPANION_RELICS.getRelicChestChance(data.getState().m_60734_(), data.getRarity());
        probability = CommonEvents.CHEST_RELIC_GENERATION.invoke(data.getPlayer(), probability).getProbability();
        this.addCompanionLoot(probability, vault.get(Vault.LEVEL).get(), data.getRandom(), data.getLoot());
        double particleChance = ModConfigs.COMPANION_RELICS.getParticleChance(data.getState().m_60734_(), data.getRarity());
        if ((double)data.getRandom().nextFloat() < particleChance) {
            data.getLoot().add(CompanionParticleTrailItem.createRandom());
        }
    }

    protected void generateRelicFragmentsTreasureSand(LootableBlockGenerationEvent.Data data, Vault vault) {
        if (data.getState().m_60734_() != ModBlocks.TREASURE_SAND) {
            return;
        }
        if (data.getPlayer() == null) {
            return;
        }
        Optional<ItemStack> companionOpt = CompanionItem.getCompanion((LivingEntity)data.getPlayer());
        if (companionOpt.isEmpty()) {
            return;
        }
        if (CompanionItem.getCompanionHearts(companionOpt.get()) <= 0 || !CompanionItem.isActive(companionOpt.get())) {
            return;
        }
        if (vault.has(Vault.LEVEL) && vault.get(Vault.LEVEL).get() < ModConfigs.COMPANION_RELICS.getRelicMinLevel()) {
            return;
        }
        double probability = ModConfigs.COMPANION_RELICS.getRelicChestChance(data.getState().m_60734_(), VaultRarity.OMEGA);
        this.addCompanionLoot(probability, vault.get(Vault.LEVEL).get(), data.getRandom(), data.getLoot());
        double particleChance = ModConfigs.COMPANION_RELICS.getParticleChance(data.getState().m_60734_(), VaultRarity.OMEGA);
        if ((double)data.getRandom().nextFloat() < particleChance) {
            data.getLoot().add(CompanionParticleTrailItem.createRandom());
        }
    }

    private void addCompanionLoot(double probability, int level, RandomSource random, List<ItemStack> loot) {
        if ((double)random.nextFloat() < probability) {
            ModConfigs.COMPANION_RELICS.getRandom(level, random).ifPresent(entry -> {
                ItemStack stack = CompanionRelicItem.create(entry.getModifiers(), entry.getModel().get(JavaRandom.ofNanoTime()));
                loot.add(stack);
            });
        }
    }
}

