/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault;

import iskallia.vault.VaultMod;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.ClientEvents;
import iskallia.vault.core.vault.EntityState;
import iskallia.vault.core.vault.PortalData;
import iskallia.vault.core.vault.PortalLogic;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.util.ServerScheduler;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ClassicPortalLogic
extends PortalLogic {
    public static final SupplierKey<PortalLogic> KEY = (SupplierKey)SupplierKey.of("classic", PortalLogic.class).with(Version.v1_0, (PortalLogic)((Object)((Supplier<PortalLogic>)ClassicPortalLogic::new)));
    public static final ResourceLocation ENTRANCE = VaultMod.id("entrance");
    public static final ResourceLocation EXIT = VaultMod.id("exit");
    public static final FieldRegistry FIELDS = PortalLogic.FIELDS.merge(new FieldRegistry());

    @Override
    public SupplierKey<PortalLogic> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initClient(Vault vault) {
        ClientEvents.COMPASS_PROPERTY.register(vault, data -> this.getPlayerStartPos(vault).ifPresent(data::setTarget));
    }

    public Optional<BlockPos> getStart() {
        return this.getPortals(ENTRANCE).findAny().map(portalData -> {
            BlockPos min = portalData.get(PortalData.MIN);
            BlockPos max = portalData.get(PortalData.MAX);
            return new BlockPos((min.m_123341_() + max.m_123341_()) / 2, min.m_123342_(), (min.m_123343_() + max.m_123343_()) / 2);
        });
    }

    public Optional<EntityState> getPlayerStart(Level world, Vault vault) {
        return this.getPlayerStartPos(vault).map(pos -> {
            Direction facing = vault.get(Vault.WORLD).get(WorldManager.FACING);
            return (EntityState)((EntityState)((EntityState)((EntityState)((EntityState)((EntityState)new EntityState().set(EntityState.POS_X, (double)pos.m_123341_() + 0.5)).set(EntityState.POS_Y, Double.valueOf(pos.m_123342_()))).set(EntityState.POS_Z, (double)pos.m_123343_() + 0.5)).set(EntityState.PITCH, Float.valueOf(0.0f))).set(EntityState.YAW, Float.valueOf(facing.m_122435_()))).set(EntityState.WORLD, world.m_46472_());
        });
    }

    public Optional<BlockPos> getPlayerStartPos(Vault vault) {
        return this.getPortals(ENTRANCE).findAny().map(portalData -> {
            BlockPos min = portalData.get(PortalData.MIN);
            BlockPos max = portalData.get(PortalData.MAX);
            BlockPos pos = new BlockPos((min.m_123341_() + max.m_123341_()) / 2, min.m_123342_(), (min.m_123343_() + max.m_123343_()) / 2);
            Direction facing = vault.get(Vault.WORLD).get(WorldManager.FACING);
            return pos.m_5484_(facing, 5);
        });
    }

    public void placeStartTrapdoors(VirtualWorld world, Vault vault) {
        ServerScheduler.INSTANCE.schedule(20, () -> this.getPlayerStartPos(vault).ifPresent(start -> {
            Direction facing = vault.get(Vault.WORLD).get(WorldManager.FACING);
            Direction left = facing.m_122428_();
            Direction right = facing.m_122427_();
            BlockState trapdoor = (BlockState)((BlockState)((BlockState)ModBlocks.BARRED_TRAPDOOR.m_49966_().m_61124_((Property)TrapDoorBlock.f_57514_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)TrapDoorBlock.f_54117_, (Comparable)facing.m_122424_())).m_61124_((Property)TrapDoorBlock.f_57515_, (Comparable)Half.BOTTOM);
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            BlockPos base = start.m_5484_(facing, 13).m_5484_(left, 1).m_6630_(1);
            for (int y = -1; y <= 6; ++y) {
                for (int offset = 0; offset <= 2; ++offset) {
                    pos.m_122190_((Vec3i)base).m_122175_(right, offset).m_122175_(Direction.UP, y);
                    world.m_7731_((BlockPos)pos, trapdoor, 3);
                }
            }
        }));
    }
}

