/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.key.LootTableKey;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.world.loot.generator.LootTableGenerator;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.LootInitialization;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.CapabilityProvider;

public class CrateLootGenerator {
    @Nullable
    private final LootTableKey lootTable;
    private final float itemQuantity;
    private final List<ItemStack> additionalItems;
    private final boolean addArtifact;
    private final float artifactChance;

    public CrateLootGenerator(@Nullable LootTableKey lootTable, float itemQuantity, List<ItemStack> additionalItems, boolean addArtifact, float artifactChance) {
        this.lootTable = lootTable;
        this.itemQuantity = itemQuantity;
        this.additionalItems = additionalItems;
        this.addArtifact = addArtifact;
        this.artifactChance = artifactChance;
    }

    public NonNullList<ItemStack> generate(Vault vault, Listener listener, RandomSource random) {
        NonNullList<ItemStack> loot = this.createLoot(vault, listener, random);
        for (int i = 0; i < loot.size(); ++i) {
            ItemStack stack = (ItemStack)loot.get(i);
            stack = LootInitialization.initializeVaultLoot(stack, vault, null);
            loot.set(i, (Object)stack);
        }
        return loot;
    }

    public NonNullList<ItemStack> createLoot(Vault vault, Listener listener, RandomSource random) {
        NonNullList loot = NonNullList.m_122779_();
        if (this.lootTable != null) {
            LootTableGenerator generator = new LootTableGenerator(vault.get(Vault.VERSION), this.lootTable, this.itemQuantity);
            generator.generate(random);
            generator.getItems().forEachRemaining(arg_0 -> loot.add(arg_0));
        }
        this.additionalItems.forEach(stack -> loot.add((Object)stack.m_41777_()));
        this.mergeLoot((NonNullList<ItemStack>)loot);
        loot.removeIf(ItemStack::m_41619_);
        NonNullList<ItemStack> specialLoot = this.createSpecialLoot(listener, random);
        loot.addAll(specialLoot);
        Collections.shuffle(loot);
        return loot;
    }

    private void mergeLoot(NonNullList<ItemStack> loot) {
        ArrayList<ItemStack> merged = new ArrayList<ItemStack>();
        for (ItemStack stack : loot) {
            for (ItemStack result : merged) {
                if (!result.m_150930_(stack.m_41720_()) || result.m_41782_() ^ stack.m_41782_() || !result.areCapsCompatible((CapabilityProvider)stack) || result.m_41782_() && !result.m_41783_().equals((Object)stack.m_41783_())) continue;
                int difference = Math.min(stack.m_41613_(), result.m_41741_() - result.m_41613_());
                stack.m_41774_(difference);
                result.m_41769_(difference);
            }
            if (stack.m_41619_()) continue;
            merged.add(stack.m_41777_());
        }
        loot.clear();
        loot.addAll(merged);
    }

    public NonNullList<ItemStack> createSpecialLoot(@Nullable Listener listener, RandomSource random) {
        NonNullList loot = NonNullList.m_122779_();
        if (this.addArtifact) {
            float probability = this.artifactChance;
            if (listener != null) {
                probability = CommonEvents.ARTIFACT_CHANCE.invoke(listener, probability).getProbability();
            }
            if (random.nextFloat() < probability) {
                loot.add((Object)new ItemStack((ItemLike)ModItems.UNIDENTIFIED_ARTIFACT));
            }
        }
        if (random.nextFloat() < ModConfigs.AUGMENT.getDropChance()) {
            loot.add((Object)new ItemStack((ItemLike)ModItems.AUGMENT));
        }
        return loot;
    }

    public NonNullList<ItemStack> createLootForCommand(RandomSource random, int vaultLevel) {
        int i;
        NonNullList loot = NonNullList.m_122779_();
        if (this.lootTable != null) {
            LootTableGenerator generator = new LootTableGenerator(Version.v1_0, this.lootTable, this.itemQuantity);
            generator.generate(random);
            generator.getItems().forEachRemaining(arg_0 -> loot.add(arg_0));
        }
        loot.removeIf(ItemStack::m_41619_);
        NonNullList<ItemStack> specialLoot = this.createSpecialLoot(null, random);
        for (i = 0; i < loot.size() - 54 + specialLoot.size(); ++i) {
            loot.remove(random.nextInt(loot.size()));
        }
        loot.addAll(specialLoot);
        Collections.shuffle(loot);
        for (i = 0; i < loot.size(); ++i) {
            ItemStack stack = (ItemStack)loot.get(i);
            stack = LootInitialization.initializeVaultLoot(stack, vaultLevel);
            loot.set(i, (Object)stack);
        }
        return loot;
    }
}

