/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataObject;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.data.key.registry.ISupplierKey;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.ChestGenerationEvent;
import iskallia.vault.core.event.common.CoinStacksGenerationEvent;
import iskallia.vault.core.event.common.LootableBlockGenerationEvent;
import iskallia.vault.core.event.common.OreLootGenerationEvent;
import iskallia.vault.core.event.common.ShopPedestalGenerationEvent;
import iskallia.vault.core.event.common.VaultRoyaleCrateGenerationEvent;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.util.LootInitialization;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;

public abstract class LootLogic
extends DataObject<LootLogic>
implements ISupplierKey<LootLogic> {
    public static final FieldRegistry FIELDS = new FieldRegistry();

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    public void initServer(VirtualWorld world, Vault vault) {
        CommonEvents.CHEST_LOOT_GENERATION.pre().register(vault, data -> {
            if (data.getTileEntity().m_58904_() != world) {
                return;
            }
            data.setVersion(vault.get(Vault.VERSION));
            data.setRandom(this.createPositionRandom(vault, data.getPos()));
            this.onChestPreGenerate(world, vault, (ChestGenerationEvent.Data)data);
        });
        CommonEvents.CHEST_LOOT_GENERATION.post().register(vault, data -> {
            if (data.getTileEntity().m_58904_() != world) {
                return;
            }
            this.onChestPostGenerate(world, vault, (ChestGenerationEvent.Data)data);
        });
        CommonEvents.VAULT_ROYALE_CRATE_LOOT_GENERATION.pre().register(vault, data -> {
            if (data.getTileEntity().m_58904_() != world) {
                return;
            }
            data.setVersion(vault.get(Vault.VERSION));
            data.setRandom(this.createPositionRandom(vault, data.getPos()));
            this.onRoyaleCratePreGenerate(world, vault, (VaultRoyaleCrateGenerationEvent.Data)data);
        });
        CommonEvents.VAULT_ROYALE_CRATE_LOOT_GENERATION.post().register(vault, data -> {
            if (data.getTileEntity().m_58904_() != world) {
                return;
            }
            this.onRoyaleCratePostGenerate(world, vault, (VaultRoyaleCrateGenerationEvent.Data)data);
        });
        CommonEvents.LOOTABLE_BLOCK_GENERATION_EVENT.pre().register(vault, data -> {
            if (data.getTileEntity().m_58904_() != world) {
                return;
            }
            data.setVersion(vault.get(Vault.VERSION));
            data.setRandom(this.createPositionRandom(vault, data.getPos()));
            this.onBlockPreGenerate(world, vault, (LootableBlockGenerationEvent.Data)data);
        });
        CommonEvents.LOOTABLE_BLOCK_GENERATION_EVENT.post().register(vault, data -> {
            if (data.getTileEntity().m_58904_() != world) {
                return;
            }
            this.onBlockPostGenerate(world, vault, (LootableBlockGenerationEvent.Data)data);
        });
        CommonEvents.SHOP_PEDESTAL_LOOT_GENERATION.register(vault, data -> {
            if (data.getTileEntity().m_58904_() != world) {
                return;
            }
            data.setRandom(this.createPositionRandom(vault, data.getPos()));
            this.onShopPedestalGenerate(world, vault, (ShopPedestalGenerationEvent.Data)data);
        });
        CommonEvents.COIN_STACK_LOOT_GENERATION.post().register(vault, data -> {
            if (data.getTileEntity().m_58904_() != world) {
                return;
            }
            this.onCoinPilePostGenerate(world, vault, (CoinStacksGenerationEvent.Data)data);
        });
        CommonEvents.ORE_LOOT_GENERATION_EVENT.register(vault, data -> {
            if (data.getTileEntity().m_58904_() != world) {
                return;
            }
            this.onOreLootPostGenerate(world, vault, (OreLootGenerationEvent.Data)data);
        });
    }

    private JavaRandom createPositionRandom(Vault vault, BlockPos at) {
        JavaRandom random = JavaRandom.ofInternal(vault.get(Vault.SEED));
        long a = random.nextLong() | 1L;
        long b = random.nextLong() | 1L;
        long c = random.nextLong() | 1L;
        int x = at.m_123341_();
        int y = at.m_123342_();
        int z = at.m_123343_();
        if (vault.get(Vault.VERSION).isOlderThan(Version.v1_5)) {
            random.setSeed(a * (long)x + b * (long)y + c + (long)z ^ vault.get(Vault.SEED));
        } else {
            random.setSeed(a * (long)x + b * (long)y + c * (long)z ^ vault.get(Vault.SEED));
        }
        return random;
    }

    protected abstract void onChestPreGenerate(VirtualWorld var1, Vault var2, ChestGenerationEvent.Data var3);

    protected abstract void onChestPostGenerate(VirtualWorld var1, Vault var2, ChestGenerationEvent.Data var3);

    protected abstract void onRoyaleCratePreGenerate(VirtualWorld var1, Vault var2, VaultRoyaleCrateGenerationEvent.Data var3);

    protected abstract void onRoyaleCratePostGenerate(VirtualWorld var1, Vault var2, VaultRoyaleCrateGenerationEvent.Data var3);

    protected abstract void onBlockPreGenerate(VirtualWorld var1, Vault var2, LootableBlockGenerationEvent.Data var3);

    protected abstract void onBlockPostGenerate(VirtualWorld var1, Vault var2, LootableBlockGenerationEvent.Data var3);

    protected abstract void onShopPedestalGenerate(VirtualWorld var1, Vault var2, ShopPedestalGenerationEvent.Data var3);

    protected abstract void onCoinPilePostGenerate(VirtualWorld var1, Vault var2, CoinStacksGenerationEvent.Data var3);

    protected abstract void onOreLootPostGenerate(VirtualWorld var1, Vault var2, OreLootGenerationEvent.Data var3);

    protected void initializeLoot(Vault vault, List<ItemStack> loot, BlockPos pos, RandomSource random) {
        loot.replaceAll(stack -> this.initializeLoot(vault, (ItemStack)stack, pos, random));
    }

    protected ItemStack initializeLoot(Vault vault, ItemStack stack, BlockPos pos, RandomSource random) {
        return LootInitialization.initializeVaultLoot(stack, vault, pos, random);
    }
}

