/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault;

import com.google.gson.annotations.Expose;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.vault.CompoundAdapter;
import iskallia.vault.core.data.compound.UUIDList;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.init.ModConfigs;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class NaturalSpawner
extends DataObject<NaturalSpawner> {
    public static final FieldRegistry FIELDS = new FieldRegistry();
    public static final FieldKey<Integer> BASE_MAX_MOBS = (FieldKey)FieldKey.of("base_max_mobs", Integer.class).with(Version.v1_0, Adapters.INT_SEGMENTED_3, DISK.all()).register(FIELDS);
    public static final FieldKey<Integer> EXTRA_MAX_MOBS = (FieldKey)FieldKey.of("extra_max_mobs", Integer.class).with(Version.v1_0, Adapters.INT_SEGMENTED_3, DISK.all()).register(FIELDS);
    public static final FieldKey<Integer> MIN_SPAWN_DISTANCE = (FieldKey)FieldKey.of("min_spawn_distance", Integer.class).with(Version.v1_0, Adapters.INT_SEGMENTED_3, DISK.all()).register(FIELDS);
    public static final FieldKey<Integer> MAX_SPAWN_DISTANCE = (FieldKey)FieldKey.of("max_spawn_distance", Integer.class).with(Version.v1_0, Adapters.INT_SEGMENTED_3, DISK.all()).register(FIELDS);
    public static final FieldKey<Integer> DESPAWN_DISTANCE = (FieldKey)FieldKey.of("despawn_distance", Integer.class).with(Version.v1_0, Adapters.INT_SEGMENTED_3, DISK.all()).register(FIELDS);
    public static final FieldKey<UUIDList> SPAWNED_MOBS = (FieldKey)FieldKey.of("spawned_mobs", UUIDList.class).with(Version.v1_0, CompoundAdapter.of(UUIDList::create), DISK.all()).register(FIELDS);

    public NaturalSpawner() {
        this.set(EXTRA_MAX_MOBS, 0);
        this.set(SPAWNED_MOBS, UUIDList.create());
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    public NaturalSpawner setConfig(Config config) {
        this.set(BASE_MAX_MOBS, config.baseMaxMobs);
        this.set(MIN_SPAWN_DISTANCE, config.minSpawnDistance);
        this.set(MAX_SPAWN_DISTANCE, config.maxSpawnDistance);
        this.set(DESPAWN_DISTANCE, config.despawnDistance);
        return this;
    }

    public void tickServer(VirtualWorld world, Vault vault, Listener listener) {
        if (world.m_46791_() == Difficulty.PEACEFUL) {
            return;
        }
        if (!world.m_46469_().m_46207_(GameRules.f_46134_)) {
            return;
        }
        listener.getPlayer().ifPresent(player -> {
            this.updateSpawnedMobs(world, (ServerPlayer)player);
            int maxMobs = this.get(BASE_MAX_MOBS) + this.get(EXTRA_MAX_MOBS);
            if (this.get(SPAWNED_MOBS).size() > maxMobs) {
                return;
            }
            if (this.get(MAX_SPAWN_DISTANCE) <= 0) {
                return;
            }
            for (int i = 0; i < 50 && this.get(SPAWNED_MOBS).size() < maxMobs; ++i) {
                this.attemptSpawn(world, vault, (ServerPlayer)player, world.m_5822_());
            }
        });
    }

    protected void updateSpawnedMobs(VirtualWorld world, ServerPlayer player) {
        this.get(SPAWNED_MOBS).removeIf(uuid -> {
            double despawnDistance;
            Entity entity = world.m_8791_((UUID)uuid);
            if (entity == null) {
                return true;
            }
            double distanceSq = entity.m_20280_((Entity)player);
            if (distanceSq > (despawnDistance = (double)this.get(DESPAWN_DISTANCE).intValue()) * despawnDistance) {
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
                return true;
            }
            return false;
        });
    }

    public LivingEntity attemptSpawn(VirtualWorld world, Vault vault, ServerPlayer player, Random random) {
        return this.attemptSpawn(world, vault, player, random, false);
    }

    public LivingEntity attemptSpawn(VirtualWorld world, Vault vault, ServerPlayer player, Random random, boolean shouldDespawn) {
        double min = this.getOr(MIN_SPAWN_DISTANCE, 1).intValue();
        double max = this.getOr(MAX_SPAWN_DISTANCE, 5).intValue();
        double angle = Math.PI * 2 * random.nextDouble();
        double distance = Math.sqrt(random.nextDouble() * (max * max - min * min) + min * min);
        int x = (int)Math.ceil(distance * Math.cos(angle));
        int z = (int)Math.ceil(distance * Math.sin(angle));
        double xzRadius = Math.sqrt(x * x + z * z);
        double yRange = Math.sqrt(max * max - xzRadius * xzRadius);
        int y = random.nextInt((int)Math.ceil(yRange) * 2 + 1) - (int)Math.ceil(yRange);
        BlockPos pos = player.m_142538_();
        LivingEntity spawned = NaturalSpawner.spawnMob(world, vault, pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z, random);
        if (spawned != null) {
            if (!shouldDespawn && spawned instanceof Mob) {
                Mob mob = (Mob)spawned;
                mob.m_21530_();
            }
            this.get(SPAWNED_MOBS).add(spawned.m_142081_());
        }
        return spawned;
    }

    @Nullable
    public static LivingEntity spawnMob(VirtualWorld world, Vault vault, int x, int y, int z, Random random) {
        LivingEntity entity = NaturalSpawner.createMob(world, vault.get(Vault.LEVEL).get(), random);
        BlockState state = world.m_8055_(new BlockPos(x, y - 1, z));
        if (!state.m_60643_((BlockGetter)world, new BlockPos(x, y - 1, z), entity.m_6095_())) {
            return null;
        }
        AABB entityBox = entity.m_6095_().m_20585_((double)x + 0.5, (double)y, (double)z + 0.5);
        if (!world.m_45772_(entityBox)) {
            return null;
        }
        entity.m_7678_((double)((float)x + 0.5f), (double)((float)y + 0.2f), (double)((float)z + 0.5f), (float)(random.nextDouble() * 2.0 * Math.PI), 0.0f);
        if (entity instanceof Mob) {
            ((Mob)entity).m_21373_();
            ((Mob)entity).m_6518_((ServerLevelAccessor)world, new DifficultyInstance(Difficulty.PEACEFUL, 13000L, 0L, 0.0f), MobSpawnType.STRUCTURE, null, null);
        }
        world.m_8847_((Entity)entity);
        return entity;
    }

    private static LivingEntity createMob(VirtualWorld world, int vaultLevel, Random random) {
        return ModConfigs.VAULT_MOBS.getForLevel((int)vaultLevel).MOB_POOL.getRandom(random).orElseThrow().create((Level)world);
    }

    public static class Config {
        @Expose
        public final int baseMaxMobs;
        @Expose
        public final int minSpawnDistance;
        @Expose
        public final int maxSpawnDistance;
        @Expose
        public final int despawnDistance;

        private Config() {
            this(0, 0, 0, 0);
        }

        public Config(int baseMaxMobs, int minSpawnDistance, int maxSpawnDistance, int despawnDistance) {
            this.baseMaxMobs = baseMaxMobs;
            this.minSpawnDistance = minSpawnDistance;
            this.maxSpawnDistance = maxSpawnDistance;
            this.despawnDistance = despawnDistance;
        }
    }
}

