/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault;

import iskallia.vault.VaultMod;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataMap;
import iskallia.vault.core.data.DataObject;
import iskallia.vault.core.data.adapter.vault.CompoundAdapter;
import iskallia.vault.core.data.adapter.vault.DirectAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.util.RegionPos;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.world.generator.GridGenerator;
import iskallia.vault.core.world.generator.VaultGenerator;
import iskallia.vault.core.world.generator.layout.GridLayout;
import iskallia.vault.core.world.generator.layout.VaultGridLayout;
import iskallia.vault.core.world.generator.layout.VaultLayout;
import iskallia.vault.core.world.storage.VirtualWorld;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;

public class RoomCache
extends DataObject<RoomCache> {
    public static final FieldRegistry FIELDS = new FieldRegistry();
    public static final FieldKey<RoomMap> COMMON = (FieldKey)FieldKey.of("common_rooms", RoomMap.class).with(Version.v1_41, CompoundAdapter.of(RoomMap::new), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<RoomMap> CHALLENGE = (FieldKey)FieldKey.of("challenge_rooms", RoomMap.class).with(Version.v1_41, CompoundAdapter.of(RoomMap::new), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<RoomMap> OMEGA = (FieldKey)FieldKey.of("omega_rooms", RoomMap.class).with(Version.v1_41, CompoundAdapter.of(RoomMap::new), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<RoomMap> ORE = (FieldKey)FieldKey.of("ore_rooms", RoomMap.class).with(Version.v1_41, CompoundAdapter.of(RoomMap::new), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<RoomMap> SPECIAL = (FieldKey)FieldKey.of("special_rooms", RoomMap.class).with(Version.v1_41, CompoundAdapter.of(RoomMap::new), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<RoomMap> RAW = (FieldKey)FieldKey.of("raw_rooms", RoomMap.class).with(Version.v1_41, CompoundAdapter.of(RoomMap::new), DISK.all().or(CLIENT.all())).register(FIELDS);

    public RoomCache() {
        this.set(COMMON, new RoomMap());
        this.set(CHALLENGE, new RoomMap());
        this.set(OMEGA, new RoomMap());
        this.set(ORE, new RoomMap());
        this.set(SPECIAL, new RoomMap());
        this.set(RAW, new RoomMap());
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    public void initServer(VirtualWorld world, Vault vault) {
        VaultGenerator vaultGenerator = vault.get(Vault.WORLD).get(WorldManager.GENERATOR);
        if (!(vaultGenerator instanceof GridGenerator)) {
            return;
        }
        GridGenerator generator = (GridGenerator)vaultGenerator;
        GridLayout gridLayout = generator.get(GridGenerator.LAYOUT);
        if (!(gridLayout instanceof VaultGridLayout)) {
            return;
        }
        VaultGridLayout layout = (VaultGridLayout)gridLayout;
        int cellX = generator.get(GridGenerator.CELL_X);
        int cellZ = generator.get(GridGenerator.CELL_Z);
        int radius = VaultUtils.getVaultRadius(layout, vault);
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                ResourceLocation id;
                RegionPos region = RegionPos.of(x, z, cellX, cellZ);
                VaultLayout.PieceType type = layout.getType(vault, region);
                if (type != VaultLayout.PieceType.ROOM && !type.isStart() || (id = VaultUtils.resolveRoomTemplateId(vault, layout, region)) == null) continue;
                this.getMapFor(id).put(region, id);
            }
        }
    }

    public void releaseServer() {
        CommonEvents.TEMPLATE_GENERATION.release(this);
    }

    private RoomMap getMapFor(ResourceLocation id) {
        String path = id.m_135815_();
        if (path.contains("/challenge")) {
            return this.get(CHALLENGE);
        }
        if (path.contains("/omega")) {
            return this.get(OMEGA);
        }
        if (path.contains("/ore")) {
            return this.get(ORE);
        }
        if (path.contains("/special")) {
            return this.get(SPECIAL);
        }
        if (path.contains("/raw")) {
            return this.get(RAW);
        }
        return this.get(COMMON);
    }

    public RoomMap get(RoomType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case RoomType.COMMON -> this.get(COMMON);
            case RoomType.CHALLENGE -> this.get(CHALLENGE);
            case RoomType.OMEGA -> this.get(OMEGA);
            case RoomType.ORE -> this.get(ORE);
            case RoomType.SPECIAL -> this.get(SPECIAL);
            case RoomType.RAW -> this.get(RAW);
        };
    }

    public RoomType getTypeAt(RegionPos position) {
        for (RoomType type : RoomType.values()) {
            if (!this.get(type).containsKey((Object)position)) continue;
            return type;
        }
        return null;
    }

    public static class RoomMap
    extends DataMap<RoomMap, RegionPos, ResourceLocation> {
        public RoomMap() {
            super(new ConcurrentHashMap(), new DirectAdapter<RegionPos>((value, buffer, context) -> {
                if (value == null) {
                    buffer.writeInt(0);
                    buffer.writeInt(0);
                    buffer.writeInt(0);
                    buffer.writeInt(0);
                    return;
                }
                buffer.writeInt(value.m_123341_());
                buffer.writeInt(value.m_123343_());
                buffer.writeInt(value.getSizeX());
                buffer.writeInt(value.getSizeZ());
            }, (buffer, context) -> Optional.of(RegionPos.of(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()))), new DirectAdapter<ResourceLocation>((value, buffer, context) -> buffer.writeIdentifier(value != null ? value : VaultMod.id("empty")), (buffer, context) -> Optional.of(buffer.readIdentifier())));
        }
    }

    public static enum RoomType {
        COMMON,
        CHALLENGE,
        OMEGA,
        ORE,
        SPECIAL,
        RAW;

    }
}

