/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.time.TickClock;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.gear.attribute.custom.RandomGodVaultModifierAttribute;
import iskallia.vault.gear.attribute.talent.RandomVaultModifierAttribute;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;

public class ScheduledModifiers
implements ISerializable<CompoundTag, JsonObject> {
    private final List<Entry> cache = new ArrayList<Entry>();

    public void onJoin(Vault vault, ServerPlayer player) {
        JavaRandom random = JavaRandom.ofScrambled(player.m_142081_().getLeastSignificantBits() ^ vault.get(Vault.ID).getMostSignificantBits());
        int logicalTime = vault.get(Vault.CLOCK).get(TickClock.LOGICAL_TIME);
        int displayTime = vault.get(Vault.CLOCK).get(TickClock.DISPLAY_TIME);
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)player);
        List result = snapshot.getAttributeValue(ModGearAttributes.RANDOM_VAULT_MODIFIER, VaultGearAttributeTypeMerger.asList());
        for (RandomVaultModifierAttribute attribute : result) {
            int activationTime = random.nextInt(logicalTime + displayTime);
            this.cache.add(new Entry(attribute.getModifier(), attribute.getCount(), attribute.getTime(), activationTime));
        }
        List godResults = snapshot.getAttributeValue(ModGearAttributes.RANDOM_VAULT_GOD_MODIFIER, VaultGearAttributeTypeMerger.asList());
        for (RandomGodVaultModifierAttribute attribute : godResults) {
            int activationTime = random.nextInt(logicalTime + displayTime);
            this.cache.add(new Entry(attribute.getModifier(), attribute.getCount(), attribute.getTime(), activationTime).setVaultGod(attribute.getVaultGod()));
        }
    }

    public void onTick(VirtualWorld world, Vault vault, ServerPlayer player) {
        int logicalTime = vault.get(Vault.CLOCK).get(TickClock.LOGICAL_TIME);
        JavaRandom random = JavaRandom.ofScrambled(player.m_142081_().getLeastSignificantBits() ^ vault.get(Vault.ID).getMostSignificantBits() ^ (long)logicalTime);
        random.nextLong();
        this.cache.removeIf(entry -> {
            if (entry.activationTime == logicalTime) {
                VaultModifierRegistry.getOpt(entry.modifier).ifPresent(modifier -> {
                    vault.get(Vault.MODIFIERS).addModifier((VaultModifier<?>)modifier, entry.count, true, random, context -> {
                        if (entry.timeLeft != null) {
                            context.set(ModifierContext.TICKS_LEFT, entry.timeLeft);
                        }
                    });
                    MutableComponent text = entry.vaultGod == null ? (entry.timeLeft != null ? new TextComponent("").m_7220_(player.m_5446_()).m_7220_((Component)new TextComponent(" added ").m_130940_(ChatFormatting.GRAY)).m_7220_(modifier.getChatDisplayNameComponent(entry.count)).m_7220_((Component)new TextComponent(" for ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent(entry.timeLeft / 20 + " seconds")).m_7220_((Component)new TextComponent(".").m_130940_(ChatFormatting.GRAY)) : new TextComponent("").m_7220_(player.m_5446_()).m_7220_((Component)new TextComponent(" added ").m_130940_(ChatFormatting.GRAY)).m_7220_(modifier.getChatDisplayNameComponent(entry.count)).m_7220_((Component)new TextComponent(".").m_130940_(ChatFormatting.GRAY))) : (entry.timeLeft != null ? new TextComponent("").m_7220_((Component)new TextComponent(entry.vaultGod.getName()).m_130940_(entry.vaultGod.getChatColor())).m_7220_((Component)new TextComponent(" blessed this vault with ").m_130940_(ChatFormatting.GRAY)).m_7220_(modifier.getChatDisplayNameComponent(entry.count)).m_7220_((Component)new TextComponent(" for ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent(entry.timeLeft / 20 + " seconds")).m_7220_((Component)new TextComponent(".").m_130940_(ChatFormatting.GRAY)) : new TextComponent("").m_7220_((Component)new TextComponent(entry.vaultGod.getName()).m_130940_(entry.vaultGod.getChatColor())).m_7220_((Component)new TextComponent(" blessed this vault with ").m_130940_(ChatFormatting.GRAY)).m_7220_(modifier.getChatDisplayNameComponent(entry.count)).m_7220_((Component)new TextComponent(".").m_130940_(ChatFormatting.GRAY)));
                    for (Listener listener : vault.get(Vault.LISTENERS).getAll()) {
                        listener.getPlayer().ifPresent(arg_0 -> ScheduledModifiers.lambda$onTick$1(world, (Component)text, arg_0));
                    }
                });
                return true;
            }
            return false;
        });
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        Adapters.INT_SEGMENTED_3.writeBits(this.cache.size(), buffer);
        for (Entry entry : this.cache) {
            entry.writeBits(buffer);
        }
    }

    @Override
    public void readBits(BitBuffer buffer) {
        int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        this.cache.clear();
        for (int i = 0; i < size; ++i) {
            Entry entry = new Entry();
            entry.readBits(buffer);
            this.cache.add(entry);
        }
    }

    private static /* synthetic */ void lambda$onTick$1(VirtualWorld world, Component text, ServerPlayer other) {
        world.m_6263_(null, other.m_20185_(), other.m_20186_(), other.m_20189_(), SoundEvents.f_12210_, SoundSource.PLAYERS, 0.9f, 1.2f);
        other.m_5661_(text, false);
    }

    public static class Entry
    implements ISerializable<CompoundTag, JsonObject> {
        private ResourceLocation modifier;
        private int count;
        private Integer timeLeft;
        private int activationTime;
        @Nullable
        private VaultGod vaultGod;

        public Entry() {
        }

        public Entry(ResourceLocation modifier, int count, Integer timeLeft, int activationTime) {
            this.modifier = modifier;
            this.count = count;
            this.timeLeft = timeLeft;
            this.activationTime = activationTime;
            this.vaultGod = null;
        }

        public Entry setVaultGod(@Nullable VaultGod vaultGod) {
            this.vaultGod = vaultGod;
            return this;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.IDENTIFIER.writeBits(this.modifier, buffer);
            Adapters.INT_SEGMENTED_3.writeBits(this.count, buffer);
            Adapters.INT_SEGMENTED_7.asNullable().writeBits(this.timeLeft, buffer);
            Adapters.INT_SEGMENTED_7.writeBits(this.activationTime, buffer);
            if (this.vaultGod != null) {
                Adapters.ofEnum(VaultGod.class, EnumAdapter.Mode.NAME).writeBits(this.vaultGod, buffer);
            }
        }

        @Override
        public void readBits(BitBuffer buffer) {
            this.modifier = Adapters.IDENTIFIER.readBits(buffer).orElseThrow();
            this.count = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
            this.timeLeft = (Integer)Adapters.INT_SEGMENTED_7.asNullable().readBits(buffer).orElseThrow();
            this.activationTime = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
            Adapters.ofEnum(VaultGod.class, EnumAdapter.Mode.NAME).readBits(buffer).ifPresent(god -> {
                this.vaultGod = god;
            });
        }
    }
}

