/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault;

import iskallia.vault.init.ModConfigs;
import iskallia.vault.task.Task;
import iskallia.vault.task.renderer.TaskRenderer;
import iskallia.vault.task.renderer.TeamRenderer;
import iskallia.vault.task.source.EntityTaskSource;
import iskallia.vault.task.util.IProgressTask;
import iskallia.vault.world.data.TeamTaskData;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class TeamTaskManager {
    private static final int SYNC_INTERVAL = 5;
    private static long lastSyncTime = 0L;
    private static boolean shouldCheckReclaimTasks = true;
    private static Map<Object, TaskEventListener> taskEventListeners = new HashMap<Object, TaskEventListener>();

    public static void addTaskEventListener(Object parent, TaskEventListener listener) {
        taskEventListeners.put(parent, listener);
    }

    public static void removeTaskEventListener(Object parent) {
        taskEventListeners.remove(parent);
    }

    public static void resetTasks(MinecraftServer server) {
        TeamTaskData teamTaskData = TeamTaskData.get(server);
        teamTaskData.removeAllTeamTasks();
        server.m_6846_().m_11314_().forEach(player -> {
            ServerScoreboard scoreboard = server.m_129896_();
            PlayerTeam playersTeam = scoreboard.m_83500_(player.m_36316_().getName());
            if (playersTeam == null) {
                return;
            }
            teamTaskData.syncAll((ServerPlayer)player);
            TeamTaskManager.checkAndAddPlayerInTeam(teamTaskData, player, playersTeam.m_5758_());
        });
    }

    public static boolean refreshTask(MinecraftServer server, String taskId) {
        TeamTaskData teamTaskData = TeamTaskData.get(server);
        if (teamTaskData.refreshTask(taskId, server)) {
            taskEventListeners.values().forEach(listener -> listener.onTaskRefresh(taskId));
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ServerScoreboard scoreboard = event.getPlayer().m_20194_().m_129896_();
        PlayerTeam playersTeam = scoreboard.m_83500_(event.getPlayer().m_36316_().getName());
        if (playersTeam == null) {
            return;
        }
        TeamTaskData teamTaskData = TeamTaskData.get(event.getPlayer().m_20194_());
        TeamTaskManager.checkAndAddPlayerInTeam(teamTaskData, serverPlayer, playersTeam.m_5758_());
        teamTaskData.syncAll(serverPlayer);
    }

    @SubscribeEvent
    public static void onServerStart(ServerStartedEvent event) {
        TeamTaskData teamTaskData = TeamTaskData.get(event.getServer());
        TeamTaskManager.attachTeamTasks(event, teamTaskData);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        long currentTick = server.m_129783_().m_46467_();
        if (lastSyncTime + 5L > currentTick) {
            return;
        }
        lastSyncTime = currentTick;
        TeamTaskData teamTaskData = TeamTaskData.get(server);
        if (shouldCheckReclaimTasks) {
            TeamTaskManager.addReclaimTasksForAllTeams(teamTaskData, teamTaskData.getCompletedTasks(), server);
            shouldCheckReclaimTasks = false;
            teamTaskData.m_77762_();
        }
        TeamTaskManager.checkTaskCompletion(teamTaskData, server);
        if (!teamTaskData.m_77764_()) {
            return;
        }
        teamTaskData.m_77760_(false);
        server.m_6846_().m_11268_(teamTaskData.createSyncPacket());
    }

    private static void checkTaskCompletion(TeamTaskData teamTaskData, MinecraftServer server) {
        HashMap<String, String> completedTasks = new HashMap<String, String>();
        for (Map.Entry<String, TeamTaskData.TeamTasks> entry : teamTaskData.getAllTeamTasks().entrySet()) {
            String teamName = entry.getKey();
            TeamTaskData.TeamTasks teamTasks = entry.getValue();
            teamTasks.getCompletedTasks().forEach(task -> {
                if (teamTaskData.getCompletedTaskTeam(task.getId()).isPresent()) {
                    return;
                }
                teamTaskData.addCompletedTask(task.getId(), teamName);
                completedTasks.put(task.getId(), teamName);
                TeamTaskManager.notifyAllPlayersOfTaskCompletion(server, teamName, task);
            });
        }
        completedTasks.keySet().forEach(teamTaskData::removeTaskFromTeamTasksExceptForCompletingTeam);
        TeamTaskManager.addReclaimTasksForAllTeams(teamTaskData, completedTasks, server);
    }

    private static void addReclaimTasksForAllTeams(TeamTaskData teamTaskData, Map<String, String> completedTasks, MinecraftServer server) {
        if (completedTasks.isEmpty()) {
            return;
        }
        teamTaskData.getAllTeamTasks().values().forEach(teamTasks -> TeamTaskManager.addReclaimTasksFor(teamTasks, completedTasks, server));
        teamTaskData.m_77762_();
    }

    private static void notifyAllPlayersOfTaskCompletion(MinecraftServer server, String teamName, Task task) {
        Object object;
        String string;
        ServerScoreboard scoreboard = server.m_129896_();
        PlayerTeam team = scoreboard.m_83489_(teamName);
        if (team == null) {
            return;
        }
        MutableComponent mutableComponent = new TextComponent("Team ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)team.m_83364_().m_6881_().m_130940_(team.m_7414_())).m_130946_(" has completed task ");
        TaskRenderer taskRenderer = task.getRenderer();
        if (taskRenderer instanceof TeamRenderer) {
            TeamRenderer teamRenderer = (TeamRenderer)taskRenderer;
            string = teamRenderer.name;
        } else {
            string = "";
        }
        MutableComponent mutableComponent2 = mutableComponent.m_7220_((Component)new TextComponent(string).m_130940_(ChatFormatting.GREEN));
        if (task instanceof IProgressTask) {
            IProgressTask progressTask = (IProgressTask)((Object)task);
            object = " " + progressTask.getProgress().getCurrent().intValue();
        } else {
            object = "";
        }
        MutableComponent completionMessage = mutableComponent2.m_7220_((Component)new TextComponent((String)object).m_130940_(ChatFormatting.GREEN));
        server.m_6846_().m_11314_().forEach(arg_0 -> TeamTaskManager.lambda$notifyAllPlayersOfTaskCompletion$4((Component)completionMessage, arg_0));
    }

    private static void attachTeamTasks(ServerStartedEvent event, TeamTaskData teamTaskData) {
        teamTaskData.getAllTeamTasks().values().forEach(teamTasks -> teamTasks.onAttach(event.getServer()));
    }

    @SubscribeEvent
    public static void onServerStop(ServerStoppedEvent event) {
        TeamTaskData teamTaskData = TeamTaskData.get(event.getServer());
        teamTaskData.getAllTeamTasks().values().forEach(TeamTaskData.TeamTasks::onDetach);
    }

    public static void playerAddedToTeam(String playerName, String teamName) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        ServerPlayer player = server.m_6846_().m_11255_(playerName);
        if (player == null) {
            return;
        }
        TeamTaskData teamTaskData = TeamTaskData.get(server);
        TeamTaskManager.checkAndAddPlayerInTeam(teamTaskData, player, teamName);
    }

    public static void playerRemovedFromTeam(PlayerTeam playerTeam, String playerName, String teamName) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        ServerPlayer player = server.m_6846_().m_11255_(playerName);
        if (player == null) {
            return;
        }
        TeamTaskManager.removePlayerFromTeam(TeamTaskData.get(server), player, teamName, playerTeam.m_6809_().isEmpty());
    }

    private static void checkAndAddPlayerInTeam(TeamTaskData teamTaskData, ServerPlayer serverPlayer, String teamName) {
        teamTaskData.getAllTeamTasks().values().stream().filter(teamTasks -> teamTasks.playerInTeam(serverPlayer.m_142081_()) && !teamTasks.teamName().equals(teamName)).forEach(teamTasks -> teamTaskData.removePlayerFromTeam(serverPlayer, (TeamTaskData.TeamTasks)teamTasks));
        TeamTaskData.TeamTasks teamTasks2 = teamTaskData.getTeamTasks(teamName);
        if (teamTasks2 != null) {
            TeamTaskManager.addReclaimTasks(teamTaskData, teamTasks2, serverPlayer.m_20194_());
            if (teamTasks2.playerInTeam(serverPlayer.m_142081_())) {
                return;
            }
            teamTaskData.addPlayerToExistingTeam(serverPlayer, teamTasks2);
        } else {
            TeamTaskManager.addTeamTasks(teamTaskData, teamName, serverPlayer);
        }
    }

    private static void addTeamTasks(TeamTaskData teamTaskData, String teamName, ServerPlayer serverPlayer) {
        EntityTaskSource taskSource = EntityTaskSource.empty();
        taskSource.add(serverPlayer.m_142081_());
        TeamTaskManager.addTeamTasks(teamTaskData, teamName, serverPlayer.m_20194_(), serverPlayer, taskSource);
    }

    private static void addTeamTasks(TeamTaskData teamTaskData, String teamName, MinecraftServer server, @Nullable ServerPlayer serverPlayer, EntityTaskSource taskSource) {
        TeamTaskData.TeamTasks teamTasks = new TeamTaskData.TeamTasks(teamName, taskSource, ModConfigs.TEAM_TASKS.streamNonReclaimTasks().filter(task -> teamTaskData.getCompletedTaskTeam(task.getId()).isEmpty()).map(Task::copy).collect(Collectors.toMap(Task::getId, t -> t)));
        TeamTaskManager.addReclaimTasks(teamTaskData, teamTasks, server);
        teamTaskData.addTeamTasks(server, serverPlayer, teamName, teamTasks);
    }

    private static void addReclaimTasks(TeamTaskData teamTaskData, TeamTaskData.TeamTasks teamTasks, MinecraftServer server) {
        TeamTaskManager.addReclaimTasksFor(teamTasks, teamTaskData.getCompletedTasks(), server);
    }

    private static void addReclaimTasksFor(TeamTaskData.TeamTasks teamTasks, Map<String, String> completedTasks, MinecraftServer server) {
        completedTasks.forEach((taskId, teamName) -> ModConfigs.TEAM_TASKS.getNextTask((String)taskId).ifPresent(task -> {
            if (completedTasks.containsKey(task.getId()) || teamName.equals(teamTasks.teamName()) || teamTasks.getTask(task.getId()).isPresent()) {
                return;
            }
            teamTasks.addTask((Task)task.copy(), server);
        }));
    }

    private static void removePlayerFromTeam(TeamTaskData teamTaskData, ServerPlayer serverPlayer, String teamName, boolean lastPlayerInTeam) {
        TeamTaskData.TeamTasks teamTasks = teamTaskData.getTeamTasks(teamName);
        if (teamTasks == null) {
            return;
        }
        if (teamTasks.playerInTeam(serverPlayer.m_142081_())) {
            if (lastPlayerInTeam) {
                teamTaskData.removeTeam(teamName, serverPlayer);
            } else {
                teamTaskData.removePlayerFromTeam(serverPlayer, teamTasks);
            }
        }
    }

    public static void onConfigReload() {
        shouldCheckReclaimTasks = true;
        taskEventListeners.values().forEach(TaskEventListener::onConfigLoad);
    }

    private static /* synthetic */ void lambda$notifyAllPlayersOfTaskCompletion$4(Component completionMessage, ServerPlayer player) {
        player.m_5661_(completionMessage, false);
    }

    public static interface TaskEventListener {
        public void onTaskRefresh(String var1);

        public void onConfigLoad();
    }
}

