/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.data.adapter.vault.CompoundAdapter;
import iskallia.vault.core.data.adapter.vault.LegacyNbtAdapter;
import iskallia.vault.core.data.adapter.vault.RegistryValueAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.data.key.registry.ISupplierKey;
import iskallia.vault.core.event.ClientEvents;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.ClientVaults;
import iskallia.vault.core.vault.DiscoveryGoalsManager;
import iskallia.vault.core.vault.Modifiers;
import iskallia.vault.core.vault.QuestManager;
import iskallia.vault.core.vault.RoomCache;
import iskallia.vault.core.vault.VaultLevel;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.vault.WaypointsList;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.abyss.LegacyAbyssManager;
import iskallia.vault.core.vault.companion.CompanionEggHunt;
import iskallia.vault.core.vault.enhancement.EnhancementTaskManager;
import iskallia.vault.core.vault.influence.LegacyInfluences;
import iskallia.vault.core.vault.modifier.modifier.GameControlsModifier;
import iskallia.vault.core.vault.objective.Objectives;
import iskallia.vault.core.vault.overlay.VaultOverlay;
import iskallia.vault.core.vault.player.Listeners;
import iskallia.vault.core.vault.stat.StatsCollector;
import iskallia.vault.core.vault.time.TickClock;
import iskallia.vault.core.world.storage.VirtualWorld;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;

public class Vault
extends DataObject<Vault> {
    public static final FieldRegistry FIELDS = new FieldRegistry();
    public static final FieldKey<Version> VERSION = (FieldKey)FieldKey.of("version", Version.class).with(Version.v1_0, Adapters.ofEnum(Version.class, EnumAdapter.Mode.ORDINAL), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<UUID> ID = (FieldKey)FieldKey.of("id", UUID.class).with(Version.v1_0, Adapters.UUID, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Long> SEED = (FieldKey)FieldKey.of("seed", Long.class).with(Version.v1_0, Adapters.LONG, DISK.all()).register(FIELDS);
    public static final FieldKey<UUID> OWNER = (FieldKey)FieldKey.of("owner", UUID.class).with(Version.v1_0, Adapters.UUID, DISK.all()).register(FIELDS);
    public static final FieldKey<VaultLevel> LEVEL = (FieldKey)FieldKey.of("level", VaultLevel.class).with(Version.v1_0, CompoundAdapter.of(VaultLevel::new), DISK.all()).register(FIELDS);
    public static final FieldKey<TickClock> CLOCK = (FieldKey)FieldKey.of("clock", TickClock.class).with(Version.v1_0, RegistryValueAdapter.of(() -> VaultRegistry.CLOCK, ISupplierKey::getKey, Supplier::get), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<WorldManager> WORLD = (FieldKey)FieldKey.of("world_manager", WorldManager.class).with(Version.v1_0, CompoundAdapter.of(WorldManager::new), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<VaultOverlay> OVERLAY = (FieldKey)FieldKey.of("overlay", VaultOverlay.class).with(Version.v1_0, CompoundAdapter.of(VaultOverlay::new), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Void> FINISHED = (FieldKey)FieldKey.of("finished", Void.class).with(Version.v1_0, Adapters.ofVoid(), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Listeners> LISTENERS = (FieldKey)FieldKey.of("listeners", Listeners.class).with(Version.v1_0, CompoundAdapter.of(Listeners::new), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Objectives> OBJECTIVES = (FieldKey)FieldKey.of("objectives", Objectives.class).with(Version.v1_0, CompoundAdapter.of(Objectives::new), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Modifiers> MODIFIERS = (FieldKey)FieldKey.of("modifiers", Modifiers.class).with(Version.v1_0, CompoundAdapter.of(Modifiers::new), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<LegacyInfluences> INFLUENCES = (FieldKey)FieldKey.of("influences", LegacyInfluences.class).with(Version.v1_0, CompoundAdapter.of(LegacyInfluences::new), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<StatsCollector> STATS = (FieldKey)FieldKey.of("stats", StatsCollector.class).with(Version.v1_0, CompoundAdapter.of(StatsCollector::new), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<DiscoveryGoalsManager> DISCOVERY = (FieldKey)FieldKey.of("discovery", DiscoveryGoalsManager.class).with(Version.v1_8, CompoundAdapter.of(DiscoveryGoalsManager::new), DISK.all()).register(FIELDS);
    public static final FieldKey<QuestManager> QUESTS = (FieldKey)FieldKey.of("quests", QuestManager.class).with(Version.v1_16, CompoundAdapter.of(QuestManager::new), DISK.all()).register(FIELDS);
    public static final FieldKey<LegacyAbyssManager> ABYSS = (FieldKey)FieldKey.of("abyssal", LegacyAbyssManager.class).with(Version.v1_9, CompoundAdapter.of(LegacyAbyssManager::new), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<EnhancementTaskManager> ENHANCEMENT_TASKS = (FieldKey)FieldKey.of("enhancement_tasks", EnhancementTaskManager.class).with(Version.v1_12, CompoundAdapter.of(EnhancementTaskManager::new), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<CompoundTag> CRYSTAL = (FieldKey)FieldKey.of("crystal", CompoundTag.class).with(Version.v1_2, LegacyNbtAdapter.COMPOUND, DISK.all()).register(FIELDS);
    public static final FieldKey<WaypointsList> MAP_WAYPOINTS = (FieldKey)FieldKey.of("map_waypoints", WaypointsList.class).with(Version.v1_35, CompoundAdapter.of(WaypointsList::new), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<CompanionEggHunt> COMPANION_EGG_HUNT = (FieldKey)FieldKey.of("companion_egg_hunt", CompanionEggHunt.class).with(Version.v1_40, CompoundAdapter.of(CompanionEggHunt::new), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<RoomCache> ROOM_CACHE = (FieldKey)FieldKey.of("room_cache", RoomCache.class).with(Version.v1_41, CompoundAdapter.of(RoomCache::new), DISK.all()).register(FIELDS);

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    public void initServer(VirtualWorld world) {
        CommonEvents.SERVER_TICK.at(TickEvent.Phase.END).register(this, data -> this.tickServer(world));
        this.ifPresent(WORLD, worldSettings -> worldSettings.initServer(world, this));
        this.ifPresent(OBJECTIVES, objectives -> objectives.initServer(world, this));
        this.ifPresent(MODIFIERS, modifiers -> modifiers.initServer(world, this));
        this.ifPresent(LISTENERS, listeners -> listeners.initServer(world, this));
        this.ifPresent(DISCOVERY, discovery -> discovery.initServer(world, this));
        this.ifPresent(QUESTS, quests -> quests.initServer(world, this));
        this.ifPresent(STATS, stats -> stats.initServer(world, this));
        this.ifPresent(ENHANCEMENT_TASKS, tasksMgr -> tasksMgr.initServer(world, this));
        this.ifPresent(COMPANION_EGG_HUNT, companionEggHunt -> companionEggHunt.initServer(world, this));
        this.ifPresent(ROOM_CACHE, roomCache -> roomCache.initServer(world, this));
    }

    protected void tickServer(VirtualWorld world) {
        this.ifPresent(WORLD, worldSettings -> worldSettings.tickServer(world, this));
        this.ifPresent(OBJECTIVES, objectives -> objectives.tickServer(world, this));
        this.ifPresent(CLOCK, clock -> clock.tickServer(world));
        this.ifPresent(MODIFIERS, modifiers -> modifiers.tickServer(world, this));
        this.ifPresent(LISTENERS, listeners -> listeners.tickServer(world, this));
        this.ifPresent(COMPANION_EGG_HUNT, companionEggHunt -> companionEggHunt.tickServer(world, this));
    }

    public void releaseServer() {
        CommonEvents.release(this);
        this.ifPresent(WORLD, WorldManager::releaseServer);
        this.ifPresent(OBJECTIVES, Objectives::releaseServer);
        this.ifPresent(MODIFIERS, Modifiers::releaseServer);
        this.ifPresent(LISTENERS, Listeners::releaseServer);
        this.ifPresent(DISCOVERY, DiscoveryGoalsManager::releaseServer);
        this.ifPresent(QUESTS, QuestManager::releaseServer);
        this.ifPresent(STATS, StatsCollector::releaseServer);
        this.ifPresent(ENHANCEMENT_TASKS, EnhancementTaskManager::releaseServer);
        this.ifPresent(COMPANION_EGG_HUNT, CompanionEggHunt::releaseServer);
        this.ifPresent(ROOM_CACHE, RoomCache::releaseServer);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        ClientEvents.CLIENT_TICK.at(TickEvent.Phase.END).register(this, data -> this.tickClient());
        this.ifPresent(WORLD, worldManager -> worldManager.initClient(this));
        this.ifPresent(OVERLAY, overlay -> overlay.initClient(this));
        this.ifPresent(OBJECTIVES, objectives -> objectives.initClient(this));
        this.get(MODIFIERS).getModifiers().stream().filter(m -> m instanceof GameControlsModifier).forEach(m -> {
            GameControlsModifier.Properties currentProps;
            GameControlsModifier modifier = (GameControlsModifier)m;
            currentProps.setForward((currentProps = ClientVaults.CONTROLS_PROPERTIES).canMoveForward() && ((GameControlsModifier.Properties)modifier.properties()).canMoveForward());
            currentProps.setBackward(currentProps.canMoveBackward() && ((GameControlsModifier.Properties)modifier.properties()).canMoveBackward());
            currentProps.setJump(currentProps.canJump() && ((GameControlsModifier.Properties)modifier.properties()).canJump());
            currentProps.setSwapLeftAndRight(currentProps.isLeftAndRightSwapped() || ((GameControlsModifier.Properties)modifier.properties()).isLeftAndRightSwapped());
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void tickClient() {
        this.ifPresent(CLOCK, TickClock::tickClient);
        if (this.has(FINISHED)) {
            this.releaseClient();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void releaseClient() {
        CommonEvents.release(this);
        ClientEvents.release(this);
        ClientVaults.ACTIVE = new Vault();
        ClientVaults.CONTROLS_PROPERTIES = new GameControlsModifier.Properties(true, true, true, false);
        this.ifPresent(OVERLAY, overlay -> overlay.releaseClient(this));
    }
}

