/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault;

import iskallia.vault.VaultMod;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.key.PaletteKey;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.vault.ClassicLootLogic;
import iskallia.vault.core.vault.ClassicMobLogic;
import iskallia.vault.core.vault.ClassicPortalLogic;
import iskallia.vault.core.vault.DiscoveryGoalsManager;
import iskallia.vault.core.vault.LootLogic;
import iskallia.vault.core.vault.Modifiers;
import iskallia.vault.core.vault.QuestManager;
import iskallia.vault.core.vault.RoomCache;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.vault.WaypointsList;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.WorldRenderer;
import iskallia.vault.core.vault.companion.CompanionEggHunt;
import iskallia.vault.core.vault.enhancement.EnhancementTaskManager;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.objective.Objectives;
import iskallia.vault.core.vault.overlay.VaultOverlay;
import iskallia.vault.core.vault.player.ClassicListenersLogic;
import iskallia.vault.core.vault.player.Listeners;
import iskallia.vault.core.vault.stat.StatsCollector;
import iskallia.vault.core.vault.time.TickTimer;
import iskallia.vault.core.world.generator.GridGenerator;
import iskallia.vault.core.world.generator.VaultGenerator;
import iskallia.vault.core.world.generator.layout.ClassicVaultLayout;
import iskallia.vault.core.world.generator.layout.GridLayout;
import iskallia.vault.core.world.processor.Palette;
import iskallia.vault.item.crystal.CrystalData;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class VaultFactory {
    public static Vault create(Version version, CrystalData crystal, ServerPlayer creator) {
        long seed = crystal.getProperties().getCustomSeed() != 0L ? crystal.getProperties().getCustomSeed() : new Random().nextLong();
        JavaRandom random = JavaRandom.ofScrambled(seed);
        Vault vault = new Vault();
        VaultMod.LOGGER.info("Creating vault with seed " + seed);
        ((Vault)((Vault)((Vault)((Vault)((Vault)((Vault)((Vault)((Vault)((Vault)((Vault)((Vault)((Vault)((Vault)((Vault)((Vault)((Vault)vault.set(Vault.ID, UUID.randomUUID())).set(Vault.VERSION, version)).set(Vault.SEED, seed)).set(Vault.OWNER, creator.m_142081_())).set(Vault.CLOCK, new TickTimer())).set(Vault.WORLD, (WorldManager)((WorldManager)((WorldManager)((WorldManager)((WorldManager)((WorldManager)((WorldManager)new WorldManager().set(WorldManager.FACING, Direction.m_122407_((int)random.nextInt(4)))).set(WorldManager.RANDOM_TICK_SPEED, 0)).set(WorldManager.LOOT_LOGIC, (LootLogic)new ClassicLootLogic().setIf(ClassicLootLogic.ADD_CATALYST_FRAGMENTS, crystal::canGenerateCatalystFragments))).set(WorldManager.PORTAL_LOGIC, new ClassicPortalLogic())).set(WorldManager.MOB_LOGIC, new ClassicMobLogic())).set(WorldManager.GENERATOR, (VaultGenerator)((VaultGenerator)new GridGenerator().set(GridGenerator.CELL_X, 47)).set(GridGenerator.CELL_Z, 47))).set(WorldManager.RENDERER, new WorldRenderer()))).set(Vault.OVERLAY, new VaultOverlay())).set(Vault.OBJECTIVES, new Objectives())).set(Vault.MODIFIERS, new Modifiers())).set(Vault.LISTENERS, (Listeners)new Listeners().set(Listeners.LOGIC, new ClassicListenersLogic()))).set(Vault.STATS, new StatsCollector())).set(Vault.DISCOVERY, new DiscoveryGoalsManager())).set(Vault.ENHANCEMENT_TASKS, new EnhancementTaskManager())).set(Vault.QUESTS, new QuestManager())).set(Vault.MAP_WAYPOINTS, new WaypointsList())).set(Vault.COMPANION_EGG_HUNT, new CompanionEggHunt())).set(Vault.ROOM_CACHE, new RoomCache());
        crystal.configure(vault, random);
        VaultFactory.applyObjectiveStart(vault);
        return vault;
    }

    private static void applyObjectiveStart(Vault vault) {
        GridGenerator grid;
        GridLayout layout;
        if (!vault.has(Vault.WORLD) || !vault.has(Vault.OBJECTIVES)) {
            return;
        }
        Objectives objectives = vault.get(Vault.OBJECTIVES);
        if (objectives.get(Objectives.LIST).isEmpty()) {
            return;
        }
        Objective objective = (Objective)objectives.get(Objectives.LIST).get(0);
        if (!VaultUtils.isRoyaleVault(vault)) {
            return;
        }
        VaultGenerator generator = vault.get(Vault.WORLD).get(WorldManager.GENERATOR);
        if (generator instanceof GridGenerator && (layout = (grid = (GridGenerator)generator).get(GridGenerator.LAYOUT)) instanceof ClassicVaultLayout) {
            ClassicVaultLayout classic = (ClassicVaultLayout)layout;
            classic.set(ClassicVaultLayout.START_POOL, VaultRegistry.TEMPLATE_POOL.getKey(VaultMod.id("vault/starts/royale_starts")));
            CommonEvents.LAYOUT_TEMPLATE_GENERATION.register(objective, data -> {
                if (data.getVault() != vault) {
                    return;
                }
                if (!data.getPieceType().isStart()) {
                    return;
                }
                ResourceLocation theme = vault.get(Vault.WORLD).get(WorldManager.THEME);
                ResourceLocation id = new ResourceLocation(theme.toString().replace("classic_vault_", "universal_"));
                PaletteKey palette = VaultRegistry.PALETTE.getKey(id);
                if (id.toString().contains("chaos")) {
                    palette = VaultRegistry.PALETTE.getKey(VaultMod.id("universal_sweet"));
                }
                data.getSettings().addProcessor((Palette)palette.get(Version.latest()));
            });
        }
    }
}

