/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault;

import iskallia.vault.VaultMod;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.util.RegionPos;
import iskallia.vault.core.vault.ClientVaults;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.modifier.modifier.NoLootModifier;
import iskallia.vault.core.vault.objective.AscensionObjective;
import iskallia.vault.core.vault.objective.CakeObjective;
import iskallia.vault.core.vault.objective.GreedObjective;
import iskallia.vault.core.vault.objective.HeraldObjective;
import iskallia.vault.core.vault.objective.MonolithObjective;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.objective.PvPObjective;
import iskallia.vault.core.vault.objective.RoyaleObjective;
import iskallia.vault.core.world.generator.layout.ArchitectVaultLayout;
import iskallia.vault.core.world.generator.layout.ClassicCircleLayout;
import iskallia.vault.core.world.generator.layout.ClassicInfiniteLayout;
import iskallia.vault.core.world.generator.layout.ClassicPolygonLayout;
import iskallia.vault.core.world.generator.layout.ClassicSpiralLayout;
import iskallia.vault.core.world.generator.layout.DIYVaultLayout;
import iskallia.vault.core.world.generator.layout.VaultGridLayout;
import iskallia.vault.core.world.processor.ProcessorContext;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.core.world.template.JigsawTemplate;
import iskallia.vault.core.world.template.PlacementSettings;
import iskallia.vault.core.world.template.Template;
import iskallia.vault.world.data.ServerVaults;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.Nullable;

public class VaultUtils {
    private static final Map<UUID, Set<Class<? extends Objective>>> OBJECTIVE_CACHE = new ConcurrentHashMap<UUID, Set<Class<? extends Objective>>>();

    public static <T extends Entity> void changeDimension(ServerLevel world, T entity, final Vec3 position, final Vec3 velocity, final float yaw, final float pitch, final Consumer<T> runnable) {
        final MinecraftServer server = world.m_142572_();
        entity.changeDimension(world, new ITeleporter(){

            public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw2, Function<Boolean, Entity> repositionEntity) {
                Entity repositionedEntity = repositionEntity.apply(false);
                if (repositionedEntity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)repositionedEntity;
                    server.m_6937_((Runnable)new TickTask(server.m_129921_() + 20, () -> player.m_6756_(0)));
                }
                runnable.accept(repositionedEntity);
                return repositionedEntity;
            }

            public boolean playTeleportSound(ServerPlayer player, ServerLevel sourceWorld, ServerLevel destWorld) {
                if (sourceWorld != null && ServerVaults.get((Level)sourceWorld).isPresent() && destWorld.m_46472_() == Level.f_46428_) {
                    return false;
                }
                return destWorld.m_46472_() == Level.f_46428_;
            }

            @Nullable
            public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
                return new PortalInfo(position, velocity, yaw, pitch);
            }
        });
    }

    public static void closeVault(VirtualWorld world, Vault vault, String reason) {
        VaultMod.LOGGER.error("Vault {} was closed because {}", (Object)vault.get(Vault.ID), (Object)reason);
        world.markForDeletion();
        vault.set(Vault.FINISHED);
        vault.releaseServer();
        OBJECTIVE_CACHE.remove(vault.get(Vault.ID));
    }

    public static void moveTo(ServerLevel world, Entity entity, final Vec3 pos, Vec2 rotation) {
        entity.changeDimension(world, new ITeleporter(){

            public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                Entity repositionedEntity = repositionEntity.apply(false);
                repositionedEntity.m_6021_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
                if (repositionedEntity instanceof ServerPlayer) {
                    ((ServerPlayer)repositionedEntity).m_183503_().m_142572_().m_6937_((Runnable)new TickTask(20, () -> ((ServerPlayer)repositionedEntity).m_6756_(0)));
                }
                return repositionedEntity;
            }
        });
    }

    public static boolean isVaultLevel(Level level) {
        if (level == null) {
            return false;
        }
        if (!level.m_46472_().m_135782_().m_135827_().equals("the_vault")) {
            return false;
        }
        return level.f_46443_ ? ClientVaults.getActive().isPresent() : ServerVaults.get(level).isPresent();
    }

    public static Optional<Vault> getVault(Level level) {
        if (!level.m_46472_().m_135782_().m_135827_().equals("the_vault")) {
            return Optional.empty();
        }
        if (level.f_46443_) {
            return ClientVaults.getActive();
        }
        return ServerVaults.get(level);
    }

    public static boolean isRoyaleVault(Vault vault) {
        return VaultUtils.hasObjective(vault, RoyaleObjective.class);
    }

    public static boolean isPvPVault(Vault vault) {
        return VaultUtils.hasObjective(vault, PvPObjective.class);
    }

    public static boolean isGreedVault(Vault vault) {
        return VaultUtils.hasObjective(vault, GreedObjective.class);
    }

    public static boolean isHeraldVault(Vault vault) {
        return VaultUtils.hasObjective(vault, HeraldObjective.class);
    }

    public static boolean isAscensionVault(Vault vault) {
        return VaultUtils.hasObjective(vault, AscensionObjective.class);
    }

    public static boolean isCakeVault(Vault vault) {
        return VaultUtils.hasObjective(vault, CakeObjective.class);
    }

    public static boolean isBrazierVault(Vault vault) {
        return VaultUtils.hasObjective(vault, MonolithObjective.class);
    }

    public static boolean hasObjective(Vault vault, Class<? extends Objective> objectiveClass) {
        if (vault == null) {
            return false;
        }
        UUID id = vault.get(Vault.ID);
        Set cached = OBJECTIVE_CACHE.computeIfAbsent(id, key -> {
            VaultMod.LOGGER.debug("Caching objectives for vault {}", key);
            HashSet set = new HashSet();
            vault.get(Vault.OBJECTIVES).getAll(Objective.class).forEach(obj -> set.add(obj.getClass()));
            VaultMod.LOGGER.debug("Cached {} objectives for vault {}", (Object)set.size(), key);
            return set;
        });
        for (Class clazz : cached) {
            if (!objectiveClass.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInStartRoom(BlockPos pos) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        return x >= 0 && x <= 47 && y >= 0 && y <= 255 && z >= 0 && z <= 47;
    }

    public static boolean isTrialVault(Vault vault) {
        return vault.get(Vault.MODIFIERS).getModifiers().stream().anyMatch(modifier -> modifier instanceof NoLootModifier);
    }

    public static boolean isRaidVault(Vault vault) {
        return vault.get(Vault.WORLD).map(WorldManager.THEME, theme -> theme.toString().contains("raid"), false);
    }

    public static boolean isSpecialVault(Vault vault) {
        return VaultUtils.isRoyaleVault(vault) || VaultUtils.isGreedVault(vault) || VaultUtils.isHeraldVault(vault) || VaultUtils.isAscensionVault(vault) || VaultUtils.isPvPVault(vault) || VaultUtils.isRaidVault(vault);
    }

    public static boolean allowTemporal(Vault vault) {
        return VaultUtils.isCakeVault(vault);
    }

    public static boolean isRawVault(Vault vault) {
        if (vault == null) {
            return false;
        }
        WorldManager worldManager = vault.get(Vault.WORLD);
        if (worldManager == null) {
            return false;
        }
        ResourceLocation theme = worldManager.get(WorldManager.THEME);
        if (theme == null) {
            return false;
        }
        return theme.toString().contains("raw_vault");
    }

    public static int getVaultRadius(VaultGridLayout layout, Vault vault) {
        ClassicPolygonLayout polygon;
        ClassicCircleLayout circle;
        ClassicSpiralLayout spiral;
        if (layout instanceof ClassicSpiralLayout && (spiral = (ClassicSpiralLayout)layout).has(ClassicSpiralLayout.HALF_LENGTH)) {
            int unit = spiral.get(ClassicInfiniteLayout.TUNNEL_SPAN) + 1;
            return spiral.get(ClassicSpiralLayout.HALF_LENGTH) * unit;
        }
        if (layout instanceof ClassicCircleLayout && (circle = (ClassicCircleLayout)layout).has(ClassicCircleLayout.RADIUS)) {
            int unit = circle.get(ClassicInfiniteLayout.TUNNEL_SPAN) + 1;
            return circle.get(ClassicCircleLayout.RADIUS) * unit;
        }
        if (layout instanceof ClassicPolygonLayout && (polygon = (ClassicPolygonLayout)layout).has(ClassicPolygonLayout.VERTICES)) {
            int max = polygon.get(ClassicPolygonLayout.VERTICES).stream().mapToInt(Math::abs).max().orElse(0);
            int unit = polygon.get(ClassicInfiniteLayout.TUNNEL_SPAN) + 1;
            return max * unit;
        }
        if (layout instanceof ArchitectVaultLayout) {
            ArchitectVaultLayout arch = (ArchitectVaultLayout)layout;
            int count = arch.get(ArchitectVaultLayout.ROOM_ENTRIES).getTotalCount();
            int unit = arch.get(ArchitectVaultLayout.TUNNEL_SPAN) + 1;
            return VaultUtils.spiralRadius(count, unit);
        }
        if (layout instanceof DIYVaultLayout) {
            DIYVaultLayout diy = (DIYVaultLayout)layout;
            int count = diy.get(DIYVaultLayout.ROOM_ENTRIES).getTotalCount();
            int unit = diy.get(DIYVaultLayout.TUNNEL_SPAN) + 1;
            return VaultUtils.spiralRadius(count, unit);
        }
        if (layout instanceof ClassicInfiniteLayout) {
            ClassicInfiniteLayout infinite = (ClassicInfiniteLayout)layout;
            int unit = infinite.get(ClassicInfiniteLayout.TUNNEL_SPAN) + 1;
            return 6 * unit;
        }
        return 6;
    }

    public static int spiralRadius(int rooms, int unit) {
        double r = Math.ceil((Math.sqrt(rooms + 1) - 1.0) / 2.0);
        return (int)r * unit;
    }

    @Nullable
    public static ResourceLocation resolveRoomTemplateId(Vault vault, VaultGridLayout layout, RegionPos region) {
        ChunkRandom random = ChunkRandom.any();
        random.setRegionSeed(vault.get(Vault.SEED), region.m_123341_(), region.m_123343_(), 1234567890L);
        PlacementSettings settings = new PlacementSettings(new ProcessorContext(vault, random)).setFlags(272);
        Template template = layout.getAt(vault, region, random, settings);
        if (template instanceof JigsawTemplate) {
            JigsawTemplate jigsaw = (JigsawTemplate)template;
            template = jigsaw.getRoot();
        }
        if (template == null || template.getKey() == null) {
            return null;
        }
        return template.getKey().getId();
    }
}

