/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.ClientEvents;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.client.VaultAmbientSoundManager;
import iskallia.vault.core.world.generator.theme.Theme;
import iskallia.vault.mixin.AccessorDimensionSpecialEffects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class WorldRenderer
extends DataObject<WorldRenderer> {
    public static final FieldRegistry FIELDS = new FieldRegistry();
    public static final FieldKey<Float> AMBIENT_LIGHT = (FieldKey)FieldKey.of("ambient_light", Float.class).with(Version.v1_0, Adapters.FLOAT, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Integer> FOG_COLOR = (FieldKey)FieldKey.of("fog_color", Integer.class).with(Version.v1_0, Adapters.INT, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Integer> GRASS_COLOR = (FieldKey)FieldKey.of("grass_color", Integer.class).with(Version.v1_0, Adapters.INT, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Integer> FOLIAGE_COLOR = (FieldKey)FieldKey.of("foliage_color", Integer.class).with(Version.v1_0, Adapters.INT, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Integer> WATER_COLOR = (FieldKey)FieldKey.of("water_color", Integer.class).with(Version.v1_0, Adapters.INT, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Integer> WATER_FOG_COLOR = (FieldKey)FieldKey.of("water_fog_color", Integer.class).with(Version.v1_0, Adapters.INT, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<String> PARTICLE = (FieldKey)FieldKey.of("particle", String.class).with(Version.v1_0, Adapters.UTF_8, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Float> PARTICLE_PROBABILITY = (FieldKey)FieldKey.of("particle_probability", Float.class).with(Version.v1_0, Adapters.FLOAT, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Integer> TIME = (FieldKey)FieldKey.of("time", Integer.class).with(Version.v1_19, Adapters.INT, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<ResourceLocation> EFFECTS = (FieldKey)FieldKey.of("effects", ResourceLocation.class).with(Version.v1_19, Adapters.IDENTIFIER, DISK.all().or(CLIENT.all())).register(FIELDS);
    private float prevAmbientLight;
    private float[] ambientLightRamp;

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient(Vault vault) {
        ClientEvents.AMBIENT_LIGHT.register(vault, data -> {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            WorldManager manager = vault.get(Vault.WORLD);
            if (world == null || manager == null || !world.m_46472_().m_135782_().equals((Object)manager.get(WorldManager.KEY))) {
                return;
            }
            data.setBrightness(this.getBrightness(data.getLightLevel()));
        });
        ClientEvents.BIOME_COLORS.register(vault, data -> {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            WorldManager manager = vault.get(Vault.WORLD);
            if (world == null || manager == null || !world.m_46472_().m_135782_().equals((Object)manager.get(WorldManager.KEY))) {
                return;
            }
            switch (data.getType()) {
                case FOG: {
                    this.ifPresent(FOG_COLOR, data::setColor);
                    break;
                }
                case GRASS: {
                    this.ifPresent(GRASS_COLOR, data::setColor);
                    break;
                }
                case FOLIAGE: {
                    this.ifPresent(FOLIAGE_COLOR, data::setColor);
                    break;
                }
                case WATER: {
                    this.ifPresent(WATER_COLOR, data::setColor);
                    break;
                }
                case WATER_FOG: {
                    this.ifPresent(WATER_FOG_COLOR, data::setColor);
                }
            }
        });
        ClientEvents.AMBIENT_PARTICLE.register(vault, data -> {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            WorldManager manager = vault.get(Vault.WORLD);
            if (world == null || manager == null || !world.m_46472_().m_135782_().equals((Object)manager.get(WorldManager.KEY))) {
                return;
            }
            this.ifPresent(PARTICLE, particle -> data.setSettings(new AmbientParticleSettings(this.readParticle((String)particle), this.get(PARTICLE_PROBABILITY).floatValue())));
        });
        ClientEvents.CLIENT_TICK.register(vault, data -> {
            if (data.phase != TickEvent.Phase.END) {
                return;
            }
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            WorldManager manager = vault.get(Vault.WORLD);
            if (world == null || manager == null || !world.m_46472_().m_135782_().equals((Object)manager.get(WorldManager.KEY))) {
                return;
            }
            this.ifPresent(TIME, time -> world.m_104746_((long)time.intValue()));
            VaultAmbientSoundManager.clientTick(vault, manager);
        });
        ClientEvents.WORLD_EFFECT.register(vault, data -> {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world == null || !vault.has(Vault.WORLD) || !world.m_46472_().m_135782_().equals((Object)vault.get(Vault.WORLD).get(WorldManager.KEY))) {
                return;
            }
            this.ifPresent(EFFECTS, effects -> data.setEffects((DimensionSpecialEffects)AccessorDimensionSpecialEffects.getEffects().get(effects)));
        });
    }

    public WorldRenderer setTheme(Theme theme) {
        if (theme.getParticle() != null) {
            this.set(PARTICLE, theme.getParticle());
            this.set(PARTICLE_PROBABILITY, Float.valueOf(theme.getParticleProbability()));
        }
        return (WorldRenderer)((WorldRenderer)((WorldRenderer)((WorldRenderer)((WorldRenderer)((WorldRenderer)((WorldRenderer)((WorldRenderer)this.set(AMBIENT_LIGHT, Float.valueOf(theme.getAmbientLight()))).set(FOG_COLOR, theme.getFogColor())).set(GRASS_COLOR, theme.getGrassColor())).set(FOLIAGE_COLOR, theme.getFoliageColor())).set(WATER_COLOR, theme.getWaterColor())).set(WATER_FOG_COLOR, theme.getWaterFogColor())).set(TIME, theme.getTime())).set(EFFECTS, theme.getEffects());
    }

    public float getBrightness(int lightLevel) {
        if (this.ambientLightRamp == null || this.prevAmbientLight != this.get(AMBIENT_LIGHT).floatValue()) {
            this.ambientLightRamp = new float[16];
            for (int i = 0; i <= 15; ++i) {
                float f = (float)i / 15.0f;
                float f1 = f / (4.0f - 3.0f * f);
                this.ambientLightRamp[i] = Mth.m_14179_((float)this.get(AMBIENT_LIGHT).floatValue(), (float)f1, (float)1.0f);
            }
            this.prevAmbientLight = this.get(AMBIENT_LIGHT).floatValue();
        }
        return this.ambientLightRamp[lightLevel];
    }

    public ParticleOptions readParticle(String string) {
        StringReader reader = new StringReader(string);
        try {
            return this.readParticle(reader, (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(ResourceLocation.m_135818_((StringReader)reader)));
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private <T extends ParticleOptions> T readParticle(StringReader reader, ParticleType<T> type) throws CommandSyntaxException {
        return (T)(type == null ? null : type.m_123743_().m_5739_(type, reader));
    }
}

