/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.client;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.key.ThemeKey;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.world.generator.theme.Theme;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public final class VaultAmbientSoundManager {
    private static final VaultAmbientSoundManager INSTANCE = new VaultAmbientSoundManager();
    private static final RandomSource random = JavaRandom.ofNanoTime();
    private final List<ActiveSound> activeSounds = new ArrayList<ActiveSound>();
    private ResourceLocation activeTheme;
    private Version activeVersion;
    private static final int GLOBAL_INTERVAL_TICKS = 600;
    private int globalCooldown = 600;
    private SimpleSoundInstance currentPlaying = null;

    public static VaultAmbientSoundManager get() {
        return INSTANCE;
    }

    private VaultAmbientSoundManager() {
    }

    public static void clientTick(Vault vault, WorldManager worldManager) {
        INSTANCE.tick(vault, worldManager);
    }

    private void tick(Vault vault, WorldManager worldManager) {
        Version version;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91104_()) {
            return;
        }
        ResourceLocation themeId = worldManager != null ? worldManager.get(WorldManager.THEME) : null;
        Version version2 = version = vault != null ? vault.get(Vault.VERSION) : null;
        if (themeId == null || version == null) {
            if (!this.activeSounds.isEmpty() || this.activeTheme != null) {
                this.clear();
            }
            return;
        }
        if (!Objects.equals(themeId, this.activeTheme) || !Objects.equals(version, this.activeVersion)) {
            this.applyTheme(themeId, version);
            return;
        }
        if (this.activeSounds.isEmpty()) {
            return;
        }
        SoundManager soundManager = mc.m_91106_();
        for (ActiveSound s : this.activeSounds) {
            s.tickOwnTimer();
        }
        if (this.currentPlaying != null) {
            if (soundManager.m_120403_((SoundInstance)this.currentPlaying)) {
                return;
            }
            this.currentPlaying = null;
        }
        if (this.globalCooldown > 0) {
            --this.globalCooldown;
            return;
        }
        ActiveSound pick = this.pickReadySoundWeighted();
        if (pick == null) {
            return;
        }
        this.currentPlaying = SimpleSoundInstance.m_119766_((SoundEvent)pick.event, (float)0.4f, (float)1.0f);
        soundManager.m_120367_((SoundInstance)this.currentPlaying);
        pick.resetOwnTimer();
        this.globalCooldown = 600;
    }

    public void applyTheme(ResourceLocation themeId, Version version) {
        this.stopActiveSounds();
        this.activeTheme = themeId;
        this.activeVersion = version;
        this.activeSounds.clear();
        ThemeKey themeKey = VaultRegistry.THEME.getKey(themeId);
        if (themeKey == null) {
            return;
        }
        Theme theme = (Theme)themeKey.get(version);
        if (theme == null) {
            return;
        }
        for (Theme.AmbientSound ambientSound : theme.getAmbientSounds()) {
            SoundEvent event = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ambientSound.sound());
            if (event == null) continue;
            this.activeSounds.add(new ActiveSound(event, Math.max(0, ambientSound.minRate()), Math.max(ambientSound.minRate(), ambientSound.maxRate())));
        }
        for (ActiveSound s : this.activeSounds) {
            s.resetOwnTimer();
        }
        this.globalCooldown = 600;
        this.currentPlaying = null;
    }

    private void clear() {
        this.stopActiveSounds();
        this.activeTheme = null;
        this.activeVersion = null;
        this.activeSounds.clear();
        this.globalCooldown = 600;
        this.currentPlaying = null;
    }

    public static void shutdown() {
        INSTANCE.clear();
    }

    private void stopActiveSounds() {
        SoundManager manager = Minecraft.m_91087_().m_91106_();
        if (this.currentPlaying != null) {
            manager.m_120399_((SoundInstance)this.currentPlaying);
            this.currentPlaying = null;
        }
    }

    private ActiveSound pickReadySoundWeighted() {
        double total = 0.0;
        for (ActiveSound s : this.activeSounds) {
            if (!s.isReady()) continue;
            total += s.weight();
        }
        if (total <= 0.0) {
            return null;
        }
        double r = random.nextDouble() * total;
        for (ActiveSound s : this.activeSounds) {
            if (!s.isReady() || !((r -= s.weight()) <= 0.0)) continue;
            return s;
        }
        for (ActiveSound s : this.activeSounds) {
            if (!s.isReady()) continue;
            return s;
        }
        return null;
    }

    private static class ActiveSound {
        private final SoundEvent event;
        private final int minRate;
        private final int maxRate;
        private int nextInTicks = 0;

        private ActiveSound(SoundEvent event, int minRate, int maxRate) {
            this.event = event;
            this.minRate = Math.max(0, minRate);
            this.maxRate = Math.max(this.minRate, maxRate);
        }

        void tickOwnTimer() {
            if (this.nextInTicks > 0) {
                --this.nextInTicks;
            }
        }

        boolean isReady() {
            return this.nextInTicks <= 0;
        }

        void resetOwnTimer() {
            if (this.maxRate <= this.minRate) {
                this.nextInTicks = this.minRate;
            } else {
                int range = this.maxRate - this.minRate;
                this.nextInTicks = this.minRate + random.nextInt(range + 1);
            }
        }

        double weight() {
            double expected = (double)(this.minRate + this.maxRate) / 2.0;
            return expected > 0.0 ? 1.0 / expected : 1.0;
        }
    }
}

