/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.companion;

import iskallia.vault.VaultMod;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataObject;
import iskallia.vault.core.data.adapter.vault.CompoundAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.companion.HuntInstance;
import iskallia.vault.core.vault.companion.HuntMap;
import iskallia.vault.core.vault.objective.ArchitectObjective;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.vault.stat.StatsCollector;
import iskallia.vault.core.vault.time.TickClock;
import iskallia.vault.core.vault.time.TickTimer;
import iskallia.vault.core.world.generator.GridGenerator;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.entity.entity.FloatingItemEntity;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.CompanionEggItem;
import iskallia.vault.item.CompanionSeries;
import iskallia.vault.item.VaultCompassMode;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.world.VaultDifficulty;
import iskallia.vault.world.data.CompanionVariantUnlockData;
import iskallia.vault.world.data.PlayerCompanionEggData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import iskallia.vault.world.data.VaultPlayerCompassData;
import iskallia.vault.world.data.WorldSettings;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;

public class CompanionEggHunt
extends DataObject<CompanionEggHunt> {
    public static final FieldRegistry FIELDS = new FieldRegistry();
    public static final FieldKey<HuntMap> HUNTS = (FieldKey)FieldKey.of("hunts", HuntMap.class).with(Version.v1_40, CompoundAdapter.of(HuntMap::new), DISK.all().or(CLIENT.all())).register(FIELDS);

    public CompanionEggHunt() {
        this.set(HUNTS, new HuntMap());
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    public void initServer(VirtualWorld world, Vault vault) {
        if (VaultUtils.isSpecialVault(vault)) {
            return;
        }
        CommonEvents.LISTENER_JOIN.register(this, data -> {
            if (data.getVault() != vault) {
                return;
            }
            data.getListener().getPlayer().ifPresent(player -> this.createHunt((ServerPlayer)player, vault));
        });
        CommonEvents.LISTENER_LEAVE.register(this, data -> {
            if (data.getVault() != vault) {
                return;
            }
            UUID id = data.getListener().get(Listener.ID);
            HuntInstance hunt = (HuntInstance)this.get(HUNTS).remove(id);
            if (hunt != null && !hunt.getOr(HuntInstance.OFFERED, false).booleanValue()) {
                this.recordOutcome(id, vault.get(Vault.ID), false);
            }
        });
        CommonEvents.PLAYER_ENTITY_PICKUP.register(this, event -> {
            Player patt3225$temp = event.getPlayer();
            if (!(patt3225$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt3225$temp;
            if (player.f_19853_ != world) {
                return;
            }
            if (!(event.getItem() instanceof FloatingItemEntity)) {
                return;
            }
            if (!event.getItem().m_32055_().m_150930_((Item)ModItems.COMPANION_EGG)) {
                return;
            }
            VaultPlayerCompassData.addProgress(player, VaultCompassMode.COMPANION_EGG, 1);
            PlayerCompanionEggData.get().markCollected(player.m_142081_(), vault.get(Vault.ID));
            if (!CompanionVariantUnlockData.get(player.m_20194_()).isUnlocked(player.m_142081_(), "skeleton_husky")) {
                vault.getOptional(Vault.WORLD).ifPresent(worldManager -> worldManager.ifPresent(WorldManager.THEME, theme -> {
                    if (player.m_20194_() != null && theme.equals((Object)VaultMod.id("classic_vault_gloom"))) {
                        CompanionVariantUnlockData.get(player.m_20194_()).unlock(player.m_142081_(), "skeleton_husky");
                        CompanionVariantUnlockData.get(player.m_20194_()).syncTo(player);
                        MiscUtils.broadcast((Component)player.m_5446_().m_6881_().m_7220_((Component)new TextComponent(" has discovered the ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent("Skeleton Husky").m_130940_(ChatFormatting.DARK_PURPLE).m_7220_((Component)new TextComponent(" companion variant!").m_130940_(ChatFormatting.GRAY)))));
                    }
                }));
            }
        });
    }

    public void tickServer(VirtualWorld world, Vault vault) {
        if (VaultUtils.isSpecialVault(vault)) {
            return;
        }
        for (Map.Entry entry : this.get(HUNTS).entrySet()) {
            UUID playerId = (UUID)entry.getKey();
            HuntInstance hunt = (HuntInstance)entry.getValue();
            ServerPlayer player = world.m_142572_().m_6846_().m_11259_(playerId);
            if (player == null) continue;
            int current = vault.get(Vault.CLOCK).get(TickClock.LOGICAL_TIME);
            if (hunt.getOr(HuntInstance.OFFERED, false).booleanValue() || !hunt.has(HuntInstance.TRIGGER) || hunt.get(HuntInstance.TRIGGER) <= 0 || current < hunt.get(HuntInstance.TRIGGER)) continue;
            StatsCollector stats = vault.get(Vault.STATS);
            StatCollector playerStats = stats.get(playerId);
            int xp = playerStats.getStatsExperience(vault);
            if (!hunt.has(HuntInstance.THRESHOLD) || hunt.get(HuntInstance.THRESHOLD) <= 0 || xp < hunt.get(HuntInstance.THRESHOLD)) continue;
            if (this.offerCompanionEgg(player, vault, world)) {
                hunt.set(HuntInstance.OFFERED, true);
                this.recordOutcome(playerId, vault.get(Vault.ID), true);
                continue;
            }
            hunt.set(HuntInstance.OFFERED, false);
        }
    }

    private void createHunt(ServerPlayer player, Vault vault) {
        int n;
        HuntInstance hunt = new HuntInstance();
        int playerIdAsInt = player.m_142081_().hashCode();
        JavaRandom random = JavaRandom.ofInternal(vault.get(Vault.SEED) + (long)playerIdAsInt);
        if (random.nextInt(4) != 0) {
            this.get(HUNTS).put(player.m_142081_(), hunt);
            return;
        }
        if (player.m_20194_() == null) {
            return;
        }
        int vaultLevel = PlayerVaultStatsData.get(player.m_20194_()).getVaultStats(player.m_142081_()).getVaultLevel();
        if (vaultLevel < 50) {
            this.get(HUNTS).put(player.m_142081_(), hunt);
            return;
        }
        TickClock clock = vault.get(Vault.CLOCK);
        if (clock instanceof TickTimer) {
            TickTimer tickTimer = (TickTimer)clock;
            n = (Integer)tickTimer.get(TickTimer.DISPLAY_TIME);
        } else {
            n = 0;
        }
        int total = n;
        int start = 6000;
        int end = Math.max(start + 1, total - start);
        int trigger = Mth.m_14143_((float)(random.nextFloat() * (float)(end - start) + (float)start));
        hunt.set(HuntInstance.TRIGGER, trigger);
        int base = vaultLevel * 1000;
        float discount = PlayerCompanionEggData.get().get(player.m_142081_()).getDiscount();
        int modifierCount = (int)vault.get(Vault.MODIFIERS).getModifiers().stream().filter(mod -> ModConfigs.VAULT_CRYSTAL_CATALYST.isGood(mod.getId())).count();
        int inscriptionCount = vault.get(Vault.OBJECTIVES).getAll(ArchitectObjective.class).stream().findFirst().map(obj -> obj.get(ArchitectObjective.ROOM_ENTRIES).getTotalCount()).orElse(0);
        VaultDifficulty difficulty = WorldSettings.get((Level)player.m_183503_()).getPlayerDifficulty(player.m_142081_());
        float multiplier = CompanionEggHunt.getDifficultyMultiplier(difficulty);
        float inscriptionAddition = (float)inscriptionCount * ((float)base * 0.1f);
        float modifierAddition = (float)modifierCount * ((float)base * 0.2f);
        float randomAddition = random.nextFloat() * 0.25f * (float)base;
        int threshold = Mth.m_14143_((float)(((float)base + inscriptionAddition + modifierAddition + randomAddition) * multiplier * (1.0f - discount)));
        hunt.set(HuntInstance.THRESHOLD, threshold);
        this.get(HUNTS).put(player.m_142081_(), hunt);
    }

    private void recordOutcome(UUID playerId, UUID vaultId, boolean success) {
        PlayerCompanionEggData data = PlayerCompanionEggData.get();
        PlayerCompanionEggData.EggHuntInfo info = data.get(playerId);
        if (success) {
            info.resetDiscount();
            info.addRecord(vaultId, PlayerCompanionEggData.EggStatus.OFFERED);
        } else {
            data.get(playerId).increaseDiscount();
            info.addRecord(vaultId, PlayerCompanionEggData.EggStatus.NONE);
        }
        data.m_77762_();
    }

    public boolean offerCompanionEgg(ServerPlayer player, Vault vault, VirtualWorld world) {
        StatsCollector stats = vault.get(Vault.STATS);
        StatCollector playerStats = stats.get(player.m_142081_());
        List<BlockPos> rooms = playerStats.getRoomsDiscovered().entrySet().stream().filter(e -> !((ResourceLocation)e.getValue()).m_135815_().contains("start") && !((ResourceLocation)e.getValue()).m_135815_().contains("/special")).map(Map.Entry::getKey).toList();
        if (rooms.isEmpty()) {
            return false;
        }
        BlockPos room = rooms.get(player.m_21187_().nextInt(rooms.size()));
        int cellSize = vault.get(Vault.WORLD).map(WorldManager.GENERATOR, gen -> {
            if (gen instanceof GridGenerator) {
                GridGenerator grid = (GridGenerator)gen;
                return grid.get(GridGenerator.CELL_X);
            }
            return 47;
        }, 47);
        Vec2 center = new Vec2((float)(room.m_123341_() * cellSize) + (float)cellSize / 2.0f, (float)(room.m_123343_() * cellSize) + (float)cellSize / 2.0f);
        int half = cellSize / 2;
        BlockPos min = new BlockPos(Mth.m_14143_((float)center.f_82470_) - half, 9, Mth.m_14143_((float)center.f_82471_) - half);
        BlockPos max = new BlockPos(min.m_123341_() + cellSize - 1, 55, min.m_123343_() + cellSize - 1);
        int MAX_ATTEMPTS = 2304;
        boolean found = false;
        for (int attempts = 0; attempts < 2304; ++attempts) {
            BlockPos pos = new BlockPos(player.m_21187_().nextInt(max.m_123341_() - min.m_123341_() + 1) + min.m_123341_(), player.m_21187_().nextInt(max.m_123342_() - min.m_123342_() + 1) + min.m_123342_(), player.m_21187_().nextInt(max.m_123343_() - min.m_123343_() + 1) + min.m_123343_());
            if (!this.isAreaClear(world, pos)) continue;
            ItemStack stack = new ItemStack((ItemLike)ModItems.COMPANION_EGG);
            CompanionEggItem.setSeries(stack, CompanionSeries.getRandomSeries(JavaRandom.ofNanoTime()));
            FloatingItemEntity entity = new FloatingItemEntity((Level)world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
            entity.setColor(15186179);
            player.m_6352_((Component)new TextComponent("You have attracted the attention of a Companion Egg, go find it!").m_130940_(ChatFormatting.GREEN), Util.f_137441_);
            VaultMod.LOGGER.info("Offered companion egg to player {} at position {}", (Object)player.m_6302_(), (Object)pos);
            world.m_6263_((Player)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12210_, SoundSource.PLAYERS, 0.9f, 1.2f);
            world.m_7967_((Entity)entity);
            found = true;
            break;
        }
        if (!found) {
            VaultMod.LOGGER.warn("Failed to find valid position after {} attempts for companion egg offer for {}", (Object)2304, (Object)player.m_6302_());
            return false;
        }
        return true;
    }

    private boolean isAreaClear(VirtualWorld world, BlockPos pos) {
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dy = -2; dy <= 2; ++dy) {
                for (int dz = -2; dz <= 2; ++dz) {
                    if (world.m_8055_(pos.m_142082_(dx, dy, dz)).m_60795_()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static float getDifficultyMultiplier(VaultDifficulty difficulty) {
        return switch (difficulty) {
            default -> throw new IncompatibleClassChangeError();
            case VaultDifficulty.PIECE_OF_CAKE -> 0.2f;
            case VaultDifficulty.EASY -> 0.5f;
            case VaultDifficulty.NORMAL -> 1.0f;
            case VaultDifficulty.HARD -> 1.25f;
            case VaultDifficulty.IMPOSSIBLE -> 1.5f;
            case VaultDifficulty.FRAGGED -> 2.0f;
        };
    }

    public void releaseServer() {
        CommonEvents.release(this);
    }
}

