/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.enhancement;

import com.google.gson.JsonObject;
import iskallia.vault.block.entity.VaultEnhancementAltarTileEntity;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.util.TextComponentUtils;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public abstract class EnhancementTask<C extends Config<?>>
implements ISerializable<CompoundTag, JsonObject> {
    protected C config;
    protected UUID vault;
    protected UUID player;
    protected UUID altar;

    public EnhancementTask() {
    }

    public EnhancementTask(C config, UUID vault, UUID player, UUID altar) {
        this.config = config;
        this.vault = vault;
        this.player = player;
        this.altar = altar;
    }

    public UUID getVault() {
        return this.vault;
    }

    public UUID getPlayer() {
        return this.player;
    }

    public UUID getAltar() {
        return this.altar;
    }

    public abstract void initServer(MinecraftServer var1);

    public abstract void releaseServer();

    public abstract boolean isFinished();

    public abstract Component getProgressComponent();

    public Component getDisplay(CommandSourceStack stack) {
        return ((Config)this.config).formatDisplay(stack, this.getProgressComponent());
    }

    public boolean belongsTo(Vault vault) {
        return vault != null && vault.has(Vault.ID) && vault.get(Vault.ID).equals(this.vault);
    }

    public boolean belongsTo(Entity player) {
        return player != null && player.m_142081_().equals(this.player);
    }

    public boolean belongsTo(UUID player) {
        return player != null && player.equals(this.player);
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        Adapters.UUID.writeNbt(this.vault).ifPresent(tag -> nbt.m_128365_("vault", tag));
        Adapters.UUID.writeNbt(this.player).ifPresent(tag -> nbt.m_128365_("player", tag));
        Adapters.UUID.writeNbt(this.altar).ifPresent(tag -> nbt.m_128365_("altar", tag));
        Adapters.ENHANCEMENT_CONFIG.writeNbt((Config<?>)this.config).ifPresent(tag -> nbt.m_128365_("config", tag));
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        this.vault = Adapters.UUID.readNbt(nbt.m_128423_("vault")).orElse(null);
        this.player = Adapters.UUID.readNbt(nbt.m_128423_("player")).orElse(null);
        this.altar = Adapters.UUID.readNbt(nbt.m_128423_("altar")).orElse(null);
        this.config = Adapters.ENHANCEMENT_CONFIG.readNbt((Tag)nbt.m_128469_("config")).orElse(null);
    }

    public static abstract class Config<T extends EnhancementTask<?>>
    implements ISerializable<CompoundTag, JsonObject> {
        private String display;

        public Config() {
        }

        public Config(String display) {
            this.display = display;
        }

        public abstract T create(Vault var1, Player var2, VaultEnhancementAltarTileEntity var3, RandomSource var4);

        public Component formatDisplay(CommandSourceStack stack, Component progressStr) {
            MutableComponent cmp = Component.Serializer.m_130714_((String)this.display);
            return cmp == null ? new TextComponent("!ERROR!") : TextComponentUtils.replace(stack, (Component)cmp, "%s", progressStr);
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("display", this.display);
            return Optional.of(nbt);
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            this.display = nbt.m_128461_("display");
        }
    }
}

