/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.enhancement;

import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.vault.enhancement.EnhancementTask;
import iskallia.vault.core.world.roll.IntRoll;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public abstract class IntFilterEnhancementTask<C extends Config<?>>
extends EnhancementTask<C> {
    protected int count;
    protected int requiredCount;

    public IntFilterEnhancementTask() {
    }

    public IntFilterEnhancementTask(C config, UUID vault, UUID player, UUID altar, int requiredCount) {
        super(config, vault, player, altar);
        this.count = 0;
        this.requiredCount = requiredCount;
    }

    @Override
    public boolean isFinished() {
        return this.count >= this.requiredCount;
    }

    @Override
    public Component getProgressComponent() {
        return new TextComponent(this.count + " / " + this.requiredCount);
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.count).ifPresent(tag -> nbt.m_128365_("count", tag));
            Adapters.INT.writeNbt(this.requiredCount).ifPresent(tag -> nbt.m_128365_("requiredCount", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.count = Adapters.INT.readNbt(nbt.m_128423_("count")).orElse(0);
        this.requiredCount = Adapters.INT.readNbt(nbt.m_128423_("requiredCount")).orElse(0);
    }

    public static abstract class Config<T extends IntFilterEnhancementTask<?>>
    extends EnhancementTask.Config<T> {
        protected IntRoll range;

        public Config() {
        }

        public Config(String display, IntRoll range) {
            super(display);
            this.range = range;
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return super.writeNbt().map(nbt -> {
                Adapters.INT_ROLL.writeNbt(this.range).ifPresent(tag -> nbt.m_128365_("range", tag));
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            super.readNbt(nbt);
            this.range = Adapters.INT_ROLL.readNbt((Tag)nbt.m_128469_("range")).orElse(IntRoll.ofConstant(1));
        }
    }
}

