/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.modifier;

import com.google.common.base.Preconditions;
import iskallia.vault.core.vault.modifier.modifier.EmptyModifier;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.IVaultModifierStack;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public class VaultModifierStack
implements IVaultModifierStack,
INBTSerializable<CompoundTag> {
    public static final VaultModifierStack EMPTY = new VaultModifierStack(EmptyModifier.INSTANCE, 1);
    private VaultModifier<?> modifier;
    private int size;
    private static final String TAG_ID = "id";
    private static final String TAG_SIZE = "size";

    public IVaultModifierStack immutable() {
        return Immutable.of(this);
    }

    public static VaultModifierStack of(CompoundTag nbt) {
        return new VaultModifierStack(nbt);
    }

    public static VaultModifierStack of(@Nonnull VaultModifier<?> modifier) {
        return VaultModifierStack.of(modifier, 1);
    }

    public static VaultModifierStack of(@Nonnull VaultModifier<?> modifier, int size) {
        return new VaultModifierStack(modifier, size);
    }

    private VaultModifierStack(CompoundTag nbt) {
        this.deserializeNBT(nbt);
    }

    public VaultModifierStack(VaultModifierStack toCopy) {
        this(toCopy.modifier, toCopy.size);
    }

    public VaultModifierStack(@Nonnull VaultModifier<?> modifier, int size) {
        this.modifier = (VaultModifier)Preconditions.checkNotNull(modifier);
        this.size = size;
        this.checkAndSetEmpty();
    }

    public VaultModifierStack copy() {
        return new VaultModifierStack(this);
    }

    private void checkAndSetEmpty() {
        if (this.size <= 0) {
            this.modifier = VaultModifierStack.EMPTY.modifier;
            this.size = 1;
        }
    }

    @Override
    public VaultModifier<?> getModifier() {
        return this.modifier;
    }

    @Override
    public ResourceLocation getModifierId() {
        return this.modifier.getId();
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public VaultModifierStack setSize(int size) {
        this.size = size;
        this.checkAndSetEmpty();
        return this;
    }

    public VaultModifierStack grow(int amount) {
        this.size += amount;
        this.checkAndSetEmpty();
        return this;
    }

    public VaultModifierStack shrink(int amount) {
        return this.grow(-amount);
    }

    @Override
    public boolean isEmpty() {
        return this.modifier == VaultModifierStack.EMPTY.modifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VaultModifierStack that = (VaultModifierStack)o;
        return this.size == that.size && this.modifier.getId().equals((Object)that.modifier.getId());
    }

    public int hashCode() {
        return Objects.hash(this.modifier.getId(), this.size);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_(TAG_ID, this.modifier.getId().toString());
        nbt.m_128405_(TAG_SIZE, this.size);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ResourceLocation id = new ResourceLocation(nbt.m_128461_(TAG_ID));
        this.modifier = VaultModifierRegistry.getOrDefault(id, EmptyModifier.INSTANCE);
        this.size = nbt.m_128451_(TAG_SIZE);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.modifier.getId());
        buffer.writeInt(this.size);
    }

    public static VaultModifierStack decode(FriendlyByteBuf buffer) {
        ResourceLocation resourceLocation = buffer.m_130281_();
        EmptyModifier modifier = VaultModifierRegistry.getOrDefault(resourceLocation, EmptyModifier.INSTANCE);
        int size = buffer.readInt();
        return new VaultModifierStack(modifier, size);
    }

    public static final class Immutable
    implements IVaultModifierStack {
        private final IVaultModifierStack vaultModifierStack;

        private Immutable(IVaultModifierStack vaultModifierStack) {
            this.vaultModifierStack = vaultModifierStack;
        }

        public static Immutable of(IVaultModifierStack vaultModifierStack) {
            return new Immutable(vaultModifierStack);
        }

        @Override
        public VaultModifier<?> getModifier() {
            return this.vaultModifierStack.getModifier();
        }

        @Override
        public ResourceLocation getModifierId() {
            return this.vaultModifierStack.getModifierId();
        }

        @Override
        public int getSize() {
            return this.vaultModifierStack.getSize();
        }

        @Override
        public boolean isEmpty() {
            return this.vaultModifierStack.isEmpty();
        }
    }
}

