/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.modifier.modifier;

import com.google.gson.annotations.Expose;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.modifier.spi.predicate.IModifierImmunity;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.mana.FullManaPlayer;
import iskallia.vault.skill.ability.effect.spi.core.InstantAbility;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.SpecializedSkill;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.source.SkillSource;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.EventPriority;

public class CastOnKillModifier
extends VaultModifier<Properties> {
    public CastOnKillModifier(ResourceLocation id, Properties properties, VaultModifier.Display display) {
        super(id, properties, display);
        this.setDescriptionFormatter((t, p, s) -> t.formatted((int)Math.abs(p.getProbability() * (float)s * 100.0f)));
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault, ModifierContext context) {
        CommonEvents.ENTITY_DROPS.register((Object)context.getUUID(), EventPriority.HIGHEST, event -> {
            ServerPlayer attacker;
            Entity patt1711$temp = event.getSource().m_7639_();
            if (!(patt1711$temp instanceof ServerPlayer) || (attacker = (ServerPlayer)patt1711$temp).m_183503_().m_5776_()) {
                return;
            }
            if (attacker.f_19853_ != world) {
                return;
            }
            if (IModifierImmunity.of(event.getEntity()).test(this)) {
                return;
            }
            if (!((Properties)this.properties).filter.test(event.getEntity())) {
                return;
            }
            if (attacker.m_183503_().m_5822_().nextFloat() >= ((Properties)this.properties).probability) {
                return;
            }
            AbilityTree tree = PlayerAbilitiesData.get((ServerLevel)attacker.f_19853_).getAbilities((Player)attacker);
            this.resolve(tree).ifPresent(ability -> ability.onAction(SkillContext.of(attacker, SkillSource.of((Entity)attacker).setPos(event.getEntity().m_20182_()).setMana(FullManaPlayer.INSTANCE))));
        });
    }

    public Optional<InstantAbility> resolve(AbilityTree tree) {
        return tree.getForId(((Properties)this.properties).ability).map(skill -> {
            Skill skill2;
            if (skill instanceof SpecializedSkill) {
                SpecializedSkill specialized = (SpecializedSkill)skill;
                v0 = specialized.getSpecialization();
            } else {
                v0 = skill = skill;
            }
            if (skill instanceof TieredSkill) {
                TieredSkill tiered = (TieredSkill)skill;
                skill2 = tiered.getChild();
            } else {
                skill2 = skill;
            }
            skill = skill2;
            return (InstantAbility)(skill instanceof InstantAbility ? skill : null);
        });
    }

    @Override
    public void releaseServer(ModifierContext context) {
        CommonEvents.ENTITY_DROPS.release(context.getUUID());
    }

    public static class Properties {
        @Expose
        private EntityPredicate filter;
        @Expose
        private String ability;
        @Expose
        private float probability;

        public Properties(EntityPredicate filter, String ability, float probability) {
            this.filter = filter;
            this.ability = ability;
            this.probability = probability;
        }

        public EntityPredicate getFilter() {
            return this.filter;
        }

        public String getAbility() {
            return this.ability;
        }

        public float getProbability() {
            return this.probability;
        }
    }
}

