/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.modifier.modifier;

import com.google.gson.annotations.Expose;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.key.LootTableKey;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.vault.modifier.modifier.NoLootModifier;
import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.modifier.spi.predicate.IModifierImmunity;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.core.world.loot.generator.LootTableGenerator;
import iskallia.vault.core.world.storage.VirtualWorld;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.EventPriority;

public class DropOnKillModifier
extends VaultModifier<Properties> {
    public DropOnKillModifier(ResourceLocation id, Properties properties, VaultModifier.Display display) {
        super(id, properties, display);
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault, ModifierContext context) {
        CommonEvents.ENTITY_DROPS.register((Object)context.getUUID(), EventPriority.HIGHEST, event -> {
            ServerPlayer attacker;
            Entity patt1473$temp = event.getSource().m_7639_();
            if (!(patt1473$temp instanceof ServerPlayer) || (attacker = (ServerPlayer)patt1473$temp).m_183503_().m_5776_()) {
                return;
            }
            if (attacker.f_19853_ != world) {
                return;
            }
            if (!event.getEntity().m_19880_().contains("soul_shards")) {
                return;
            }
            if (vault.get(Vault.MODIFIERS).getModifiers().stream().anyMatch(modifier -> modifier instanceof NoLootModifier)) {
                return;
            }
            if (IModifierImmunity.of(event.getEntity()).test(this)) {
                return;
            }
            if (!((Properties)this.properties).filter.test(event.getEntity())) {
                return;
            }
            LootTableKey lootTable = VaultRegistry.LOOT_TABLE.getKey(((Properties)this.properties).lootTable);
            if (lootTable == null) {
                return;
            }
            LootTableGenerator generator = new LootTableGenerator(Version.latest(), lootTable, 0.0f);
            generator.generate(JavaRandom.ofNanoTime());
            generator.getItems().forEachRemaining(stack -> {
                ItemEntity itemEntity = new ItemEntity((Level)world, event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), stack.m_41777_());
                itemEntity.m_32060_();
                event.getDrops().add(itemEntity);
            });
        }, -100);
    }

    @Override
    public void releaseServer(ModifierContext context) {
        CommonEvents.ENTITY_DROPS.release(context.getUUID());
    }

    public static class Properties {
        @Expose
        private EntityPredicate filter;
        @Expose
        private ResourceLocation lootTable;

        public Properties(EntityPredicate filter, ResourceLocation lootTable) {
            this.filter = filter;
            this.lootTable = lootTable;
        }

        public EntityPredicate getFilter() {
            return this.filter;
        }

        public ResourceLocation getLootTable() {
            return this.lootTable;
        }
    }
}

