/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.modifier.modifier;

import com.google.gson.annotations.Expose;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.modifier.NoLootModifier;
import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.world.storage.VirtualWorld;
import net.minecraft.resources.ResourceLocation;

public class ExperienceModifier
extends VaultModifier<Properties> {
    public ExperienceModifier(ResourceLocation id, Properties properties, VaultModifier.Display display) {
        super(id, properties, display);
        this.setDescriptionFormatter((t, p, s) -> t.formatted((int)(p.getAddend() * (float)s * 100.0f)));
    }

    @Override
    public void onListenerAdd(VirtualWorld world, Vault vault, ModifierContext context, Listener listener) {
        if (context.hasTarget() && !context.getTarget().equals(listener.getId())) {
            return;
        }
        if (vault.get(Vault.MODIFIERS).getModifiers().stream().anyMatch(modifier -> modifier instanceof NoLootModifier)) {
            return;
        }
        vault.getOptional(Vault.STATS).map(stats -> stats.get(listener)).ifPresent(stats -> {
            float add = ((Properties)this.properties).getAddend();
            stats.modify(StatCollector.OBJECTIVE_EXP_MULTIPLIER, exp -> Float.valueOf(exp.floatValue() == 0.0f ? 0.0f : Math.max(0.0f, exp.floatValue() + add)));
            stats.modify(StatCollector.BONUS_EXP_MULTIPLIER, exp -> Float.valueOf(exp.floatValue() == 0.0f ? 0.0f : Math.max(0.0f, exp.floatValue() + add)));
        });
    }

    public static class Properties {
        @Expose
        private final float addend;

        public Properties(float chance) {
            this.addend = chance;
        }

        public float getAddend() {
            return this.addend;
        }
    }
}

