/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.modifier.modifier;

import com.google.gson.annotations.Expose;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.data.tile.TilePredicate;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.ClientboundHunterPositionsMessage;
import iskallia.vault.skill.ability.effect.spi.HunterAbility;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.network.NetworkDirection;

public class HunterModifier
extends VaultModifier<Properties> {
    public HunterModifier(ResourceLocation id, Properties properties, VaultModifier.Display display) {
        super(id, properties, display);
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault, ModifierContext context) {
        CommonEvents.SERVER_TICK.at(TickEvent.Phase.END).register(context.getUUID(), event -> {
            if (world.m_46467_() % 10L != 0L) {
                return;
            }
            for (Listener listener : vault.get(Vault.LISTENERS).getAll()) {
                listener.getPlayer().ifPresent(player -> {
                    ArrayList<HunterAbility.HighlightPosition> positions = new ArrayList<HunterAbility.HighlightPosition>();
                    for (Properties.Entry entry : ((Properties)this.properties).getEntries()) {
                        positions.addAll(HunterAbility.selectPositions((ServerLevel)world, (Player)player, entry.radius, tile -> HunterModifier.getHighlightPosition(entry, tile)));
                    }
                    ModNetwork.CHANNEL.sendTo((Object)new ClientboundHunterPositionsMessage(positions), player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
                });
            }
        });
        super.initServer(world, vault, context);
    }

    private static Optional<HunterAbility.HighlightPosition> getHighlightPosition(Properties.Entry entry, BlockEntity tile) {
        if (entry.filter.test(PartialTile.of(tile))) {
            return Optional.of(new HunterAbility.HighlightPosition(tile.m_58899_(), HunterAbility.Target.of(entry.target), entry.color));
        }
        return Optional.empty();
    }

    @Override
    public void releaseServer(ModifierContext context) {
        CommonEvents.SERVER_TICK.release(context.getUUID());
        super.releaseServer(context);
    }

    public static class Properties {
        @Expose
        private List<Entry> entries = new ArrayList<Entry>();

        public List<Entry> getEntries() {
            return this.entries;
        }

        public static class Entry {
            @Expose
            public TilePredicate filter;
            @Expose
            public double radius;
            @Expose
            public String target;
            @Expose
            public int color;
        }
    }
}

