/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.modifier.modifier;

import com.google.gson.annotations.Expose;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.LootGenerationEvent;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.reputation.ScalarReputationProperty;
import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.world.loot.generator.LootGenerator;
import iskallia.vault.core.world.loot.generator.TieredLootTableGenerator;
import iskallia.vault.core.world.storage.VirtualWorld;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;

public class LootItemRarityModifier
extends VaultModifier<Properties> {
    public LootItemRarityModifier(ResourceLocation id, Properties properties, VaultModifier.Display display) {
        super(id, properties, display);
        this.setDescriptionFormatter((t, p, s) -> t.formatted((int)Math.abs(p.getPercentage() * (double)s * 100.0)));
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault, ModifierContext context) {
        CommonEvents.LOOT_GENERATION.pre().register(context.getUUID(), data -> this.getGenerator(vault, (LootGenerationEvent.Data)data, context).ifPresent(generator -> {
            generator.itemRarity = (float)((double)generator.itemRarity + ((Properties)this.properties).getPercentage(context));
        }));
        CommonEvents.LOOT_GENERATION.post().register(context.getUUID(), data -> this.getGenerator(vault, (LootGenerationEvent.Data)data, context).ifPresent(generator -> {
            generator.itemRarity = (float)((double)generator.itemRarity - ((Properties)this.properties).getPercentage(context));
        }));
    }

    public Optional<TieredLootTableGenerator> getGenerator(Vault vault, LootGenerationEvent.Data data, ModifierContext context) {
        LootGenerator lootGenerator = data.getGenerator();
        if (!(lootGenerator instanceof TieredLootTableGenerator)) {
            return Optional.empty();
        }
        TieredLootTableGenerator generator = (TieredLootTableGenerator)lootGenerator;
        if (generator.getSource() == null) {
            return Optional.empty();
        }
        UUID uuid = generator.getSource().m_142081_();
        if (!vault.get(Vault.LISTENERS).contains(uuid)) {
            return Optional.empty();
        }
        if (context.hasTarget() && !context.getTarget().equals(uuid)) {
            return Optional.empty();
        }
        return Optional.of(generator);
    }

    public static class Properties {
        @Expose
        private final double percentage;
        @Expose
        private final ScalarReputationProperty reputation;

        public Properties(double percentage, ScalarReputationProperty reputation) {
            this.percentage = percentage;
            this.reputation = reputation;
        }

        public double getPercentage() {
            return this.percentage;
        }

        public double getPercentage(ModifierContext context) {
            return this.reputation != null ? this.reputation.apply(this.percentage, context) : this.percentage;
        }
    }
}

