/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.modifier.modifier;

import com.google.gson.annotations.Expose;
import iskallia.vault.block.PlaceholderBlock;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.world.storage.VirtualWorld;
import net.minecraft.resources.ResourceLocation;

public class NoLootModifier
extends VaultModifier<Properties> {
    public NoLootModifier(ResourceLocation id, Properties properties, VaultModifier.Display display) {
        super(id, properties, display);
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault, ModifierContext context) {
        CommonEvents.PLACEHOLDER_GENERATION.register(context.getUUID(), data -> {
            if (data.getVault() != vault) {
                return;
            }
            if (data.getParent().target == PlaceholderBlock.Type.OBJECTIVE || data.getParent().target == PlaceholderBlock.Type.DUNGEON_DOOR || data.getParent().target == PlaceholderBlock.Type.PYLON || data.getParent().target == PlaceholderBlock.Type.GATE) {
                return;
            }
            data.setProbability(0.0);
        });
        CommonEvents.ENTITY_READ.register(context.getUUID(), data -> {
            if (data.getEntity().m_183503_() != world) {
                return;
            }
            data.getEntity().m_20049_("no_drops");
        });
    }

    public static class Properties {
        @Expose
        private final boolean destroyChests;

        public Properties(boolean destroyChests) {
            this.destroyChests = destroyChests;
        }

        public boolean isDestroyChests() {
            return this.destroyChests;
        }
    }
}

