/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.modifier.modifier;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.player.Completion;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.vault.stat.StatsCollector;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.item.bottle.BottleItem;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.InventoryUtil;
import iskallia.vault.world.data.PhoenixModifierSnapshotData;
import iskallia.vault.world.data.ServerVaults;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerInventoryRestoreModifier
extends VaultModifier<Properties> {
    private static final String RESTORE_FLAG = "the_vault_restore_inventory";
    private static final String REVIVE_TAG = "the_vault_revived_tick";

    public PlayerInventoryRestoreModifier(ResourceLocation id, Properties properties, VaultModifier.Display display) {
        super(id, properties, display);
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        ServerLevel world;
        Player player;
        block7: {
            block6: {
                if (event.phase != TickEvent.Phase.END) {
                    return;
                }
                player = event.player;
                Level level = player.f_19853_;
                if (!(level instanceof ServerLevel)) break block6;
                world = (ServerLevel)level;
                if (player.m_6084_()) break block7;
            }
            return;
        }
        if (player.m_19880_().contains(RESTORE_FLAG)) {
            PhoenixModifierSnapshotData data = PhoenixModifierSnapshotData.get(world);
            if (data.hasSnapshot(player)) {
                data.restoreSnapshot(player);
            }
            player.m_20137_(RESTORE_FLAG);
        }
        player.m_20137_(REVIVE_TAG);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sPlayer = (ServerPlayer)livingEntity;
        if (sPlayer.f_19853_.m_5776_()) {
            return;
        }
        if (sPlayer.m_19880_().contains(REVIVE_TAG)) {
            return;
        }
        ServerVaults.get((Level)sPlayer.m_183503_()).ifPresent(vault -> {
            boolean hasRestoreModifier;
            StatCollector stats;
            int phoenixGearAttribute = AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)sPlayer).getAttributeValue(ModGearAttributes.PHOENIX, VaultGearAttributeTypeMerger.intSum());
            int phoenixUses = 0;
            if (vault.has(Vault.STATS) && (stats = vault.get(Vault.STATS).get(sPlayer.m_142081_())) != null) {
                phoenixUses = stats.getPhoenixGearUses();
            }
            boolean hasPhoenix = phoenixGearAttribute > phoenixUses;
            PlayerInventoryRestoreModifier instantRestoreModifier = null;
            for (VaultModifier<?> modifier : vault.get(Vault.MODIFIERS).getModifiers()) {
                PlayerInventoryRestoreModifier restore;
                if (!(modifier instanceof PlayerInventoryRestoreModifier) || !((Properties)(restore = (PlayerInventoryRestoreModifier)modifier).properties()).isInstantRevival()) continue;
                instantRestoreModifier = restore;
                break;
            }
            if (instantRestoreModifier != null && !event.getSource().m_19378_()) {
                if (event.getSource() == VaultMod.DMG_VAULT_TIMER) {
                    InventoryUtil.makeItemsRotten((Player)sPlayer);
                    InventoryUtil.removeRoyaleItems((Player)sPlayer);
                    return;
                }
                PlayerInventoryRestoreModifier.doVaultRevive(sPlayer, vault, instantRestoreModifier);
                event.setCanceled(true);
                sPlayer.m_20049_(REVIVE_TAG);
                return;
            }
            if (hasPhoenix && !event.getSource().m_19378_()) {
                PlayerInventoryRestoreModifier.doPhoenixRevive(sPlayer, vault, phoenixGearAttribute);
                event.setCanceled(true);
                sPlayer.m_20049_(REVIVE_TAG);
                return;
            }
            InventoryUtil.makeItemsRotten((Player)sPlayer);
            InventoryUtil.removeRoyaleItems((Player)sPlayer);
            boolean bl = hasRestoreModifier = instantRestoreModifier != null || hasPhoenix;
            if (!hasRestoreModifier || !vault.has(Vault.STATS)) {
                return;
            }
            StatsCollector statsCollector = vault.get(Vault.STATS);
            StatCollector playerStatCollector = statsCollector.get(sPlayer.m_142081_());
            if (playerStatCollector == null) {
                return;
            }
            int experience = ModConfigs.VAULT_STATS.getStatsExperience(playerStatCollector);
            int durabilityExperience = experience - ModConfigs.VAULT_STATS.getFreeExperienceNotDealtAsDurabilityDamage();
            float durabilityDamage = (float)durabilityExperience * ModConfigs.VAULT_STATS.getPercentOfExperienceDealtAsDurabilityDamage();
            if (durabilityDamage <= 0.0f) {
                return;
            }
            InventoryUtil.findAllItems((Player)sPlayer).forEach(itemAccess -> {
                ItemStack foundStack = itemAccess.getStack();
                if (foundStack.m_41720_() instanceof VaultGearItem && foundStack.m_41763_() && !(foundStack.m_41720_() instanceof BottleItem) && !VaultGearData.read(foundStack).get(ModGearAttributes.SOULBOUND, VaultGearAttributeTypeMerger.anyTrue()).booleanValue()) {
                    foundStack.m_41622_((int)durabilityDamage, (LivingEntity)sPlayer, pl -> pl.m_21190_(InteractionHand.MAIN_HAND));
                    itemAccess.setStack(foundStack);
                }
            });
        });
    }

    private static void doVaultRevive(ServerPlayer player, Vault vault, PlayerInventoryRestoreModifier modifier) {
        ModifierContext context = vault.get(Vault.MODIFIERS).getContexts(modifier).findFirst().orElse(null);
        player.m_21153_(player.m_21233_());
        player.m_21219_();
        player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 300, 1));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 200, 2));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 1));
        player.f_19853_.m_5594_(null, player.m_142538_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (context != null) {
            context.setExpired();
        }
    }

    private static void doPhoenixRevive(ServerPlayer player, Vault vault, int phoenixGearAttribute) {
        player.m_21153_(player.m_21233_());
        player.m_21219_();
        player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 300, 1));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 200, 2));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 1));
        player.f_19853_.m_5594_(null, player.m_142538_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
        vault.ifPresent(Vault.STATS, stats -> {
            StatCollector sc = stats.get(player.m_142081_());
            if (sc != null) {
                sc.modify(StatCollector.PHOENIX_GEAR_USES, u -> u + 1);
                player.m_6352_((Component)new TextComponent("You have been revived by Ann-Mari! (" + sc.getPhoenixGearUses() + "/" + phoenixGearAttribute + ")"), Util.f_137441_);
            }
        });
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault, ModifierContext context) {
        CommonEvents.ENTITY_DEATH.register(context.getUUID(), event -> {
            if (event.isCanceled()) {
                return;
            }
            LivingEntity patt9279$temp = event.getEntityLiving();
            if (!(patt9279$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt9279$temp;
            if (!player.m_183503_().equals((Object)world)) {
                return;
            }
            if (!((Properties)this.properties()).isInstantRevival()) {
                PhoenixModifierSnapshotData snapshotData = PhoenixModifierSnapshotData.get(player.m_183503_());
                if (snapshotData.hasSnapshot((Player)player)) {
                    snapshotData.removeSnapshot((Player)player);
                }
                snapshotData.createSnapshot((Player)player);
                player.m_19880_().add(RESTORE_FLAG);
            }
        });
    }

    @Override
    public void onListenerAdd(VirtualWorld world, Vault vault, ModifierContext context, Listener listener) {
        vault.getOptional(Vault.STATS).map(stats -> stats.get(listener)).ifPresent(stats -> {
            stats.modify(StatCollector.OBJECTIVE_EXP_MULTIPLIER, m -> Float.valueOf(m.floatValue() * ((Properties)this.properties()).experienceMultiplierOnSuccess()));
            stats.modify(StatCollector.BONUS_EXP_MULTIPLIER, m -> Float.valueOf(m.floatValue() * ((Properties)this.properties()).experienceMultiplierOnSuccess()));
        });
    }

    @Override
    public void onListenerRemove(VirtualWorld world, Vault vault, ModifierContext context, Listener listener) {
        vault.ifPresent(Vault.STATS, stats -> {
            StatCollector statCollector = stats.get(listener);
            if (statCollector == null || statCollector.getCompletion() != Completion.FAILED) {
                return;
            }
            statCollector.modify(StatCollector.OBJECTIVE_EXP_MULTIPLIER, m -> Float.valueOf(m.floatValue() * ((Properties)this.properties()).experienceMultiplierOnDeath()));
            statCollector.modify(StatCollector.BONUS_EXP_MULTIPLIER, m -> Float.valueOf(m.floatValue() * ((Properties)this.properties()).experienceMultiplierOnDeath()));
        });
    }

    public static class Properties {
        @Expose
        private final boolean preventsArtifact;
        @Expose
        private final float experienceMultiplierOnDeath;
        @Expose
        private final float experienceMultiplierOnSuccess;
        @Expose
        private final boolean isInstantRevival;
        @Expose
        private final float durabilityPenalty;

        public Properties(boolean preventsArtifact, float experienceMultiplierOnDeath, float experienceMultiplierOnSuccess, boolean isInstantRevival) {
            this(preventsArtifact, experienceMultiplierOnDeath, experienceMultiplierOnSuccess, isInstantRevival, 1.0f);
        }

        public Properties(boolean preventsArtifact, float experienceMultiplierOnDeath, float experienceMultiplierOnSuccess, boolean isInstantRevival, float durabilityPenalty) {
            this.preventsArtifact = preventsArtifact;
            this.experienceMultiplierOnDeath = experienceMultiplierOnDeath;
            this.experienceMultiplierOnSuccess = experienceMultiplierOnSuccess;
            this.isInstantRevival = isInstantRevival;
            this.durabilityPenalty = durabilityPenalty;
        }

        public boolean preventsArtifact() {
            return this.preventsArtifact;
        }

        public float experienceMultiplierOnDeath() {
            return this.experienceMultiplierOnDeath;
        }

        public float experienceMultiplierOnSuccess() {
            return this.experienceMultiplierOnSuccess;
        }

        public boolean isInstantRevival() {
            return this.isInstantRevival;
        }

        public float durabilityPenalty() {
            return this.durabilityPenalty;
        }
    }
}

