/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.modifier.modifier;

import com.google.gson.annotations.Expose;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.TemplateGenerationEvent;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.data.tile.TilePredicate;
import iskallia.vault.core.world.processor.tile.TileProcessor;
import iskallia.vault.core.world.storage.VirtualWorld;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class TemplateProcessorModifier
extends VaultModifier<Properties> {
    public TemplateProcessorModifier(ResourceLocation id, Properties properties, VaultModifier.Display display) {
        super(id, properties, display);
        this.setDescriptionFormatter((t, p, s) -> t.formatted((int)Math.abs(p.getProbability() * (float)s * 100.0f)));
    }

    @Override
    public void onVaultAdd(VirtualWorld world, Vault vault, ModifierContext context) {
        CommonEvents.TEMPLATE_CONFIGURATION.register(vault, data -> {
            if (data.getVault() != vault) {
                return;
            }
            TemplateGenerationEvent.Data dataNew = new TemplateGenerationEvent.Data((ServerLevelAccessor)world, null, null, null, null, null);
            data.getTemplateSettings().addProcessor(TileProcessor.of((tile, ctx) -> {
                if (((Properties)this.properties).whitelist != null && !((Properties)this.properties).whitelist.test((PartialTile)tile)) {
                    return tile;
                }
                if (((Properties)this.properties).blacklist != null && ((Properties)this.properties).blacklist.test((PartialTile)tile)) {
                    return tile;
                }
                if (ctx.getRandom(tile.getPos()).nextFloat() >= ((Properties)this.properties).probability) {
                    return tile;
                }
                BlockState state = tile.getState().asWhole().orElse(null);
                if (state == null) {
                    return tile;
                }
                List<TileProcessor> palette = state.m_60838_((BlockGetter)dataNew.getWorld(), tile.getPos()) ? ((Properties)this.properties).fullBlock : ((Properties)this.properties).partialBlock;
                for (TileProcessor processor : palette) {
                    tile = processor.process(tile, ctx);
                }
                return tile;
            }));
        });
    }

    public static class Properties {
        @Expose
        private final float probability;
        @Expose
        private final TilePredicate blacklist;
        @Expose
        private final TilePredicate whitelist;
        @Expose
        private final List<TileProcessor> fullBlock;
        @Expose
        private final List<TileProcessor> partialBlock;

        public Properties(float probability, TilePredicate blacklist, TilePredicate whitelist) {
            this.probability = probability;
            this.blacklist = blacklist;
            this.whitelist = whitelist;
            this.fullBlock = new ArrayList<TileProcessor>();
            this.partialBlock = new ArrayList<TileProcessor>();
        }

        public float getProbability() {
            return this.probability;
        }
    }
}

