/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.modifier.spi;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.core.vault.modifier.reputation.ScalarReputationProperty;
import iskallia.vault.core.vault.modifier.spi.IVaultModifierTextFormatter;
import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityAttributeModifier<P extends Properties>
extends VaultModifier<P> {
    private final long leastSignificantBits = UUID.nameUUIDFromBytes(this.getId().toString().getBytes(StandardCharsets.UTF_8)).getLeastSignificantBits();

    public EntityAttributeModifier(ResourceLocation id, P properties, VaultModifier.Display display) {
        super(id, properties, display);
        if (((Properties)properties).getType() != null) {
            this.setDescriptionFormatter(((Properties)properties).getType().getDescriptionFormatter());
        } else {
            this.setDescriptionFormatter((t, p, s) -> t);
        }
    }

    public void applyToEntity(LivingEntity entity, UUID contextUUID, ModifierContext context) {
        ModifierType modifierType = ((Properties)this.properties).getType();
        List<ResourceLocation> ids = modifierType.getAttributeResourceLocations();
        for (ResourceLocation id : ids) {
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(id);
            UUID uuid = this.getId(contextUUID);
            if (attribute == null) {
                VaultMod.LOGGER.error("Invalid entity attribute '%s' configured for vault modifier '%s'".formatted(id, this.getId()));
                return;
            }
            AttributeInstance attributeInstance = entity.m_21051_(attribute);
            if (attributeInstance == null) {
                return;
            }
            AttributeModifier modifier = attributeInstance.m_22111_(uuid);
            double amount = ((Properties)this.properties).getAmount(context);
            if (modifier != null) continue;
            attributeInstance.m_22125_(new AttributeModifier(uuid, this.getDisplayName(), amount, modifierType.getAttributeModifierOperation()));
        }
    }

    public void removeFromEntity(LivingEntity entity) {
        ModifierType modifierType = ((Properties)this.properties).getType();
        if (modifierType == null) {
            return;
        }
        List<ResourceLocation> ids = modifierType.getAttributeResourceLocations();
        for (ResourceLocation attributeResourceLocation : ids) {
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attributeResourceLocation);
            if (attribute == null) {
                VaultMod.LOGGER.error("Invalid entity attribute '%s' configured for vault modifier '%s'".formatted(attributeResourceLocation, this.getId()));
                continue;
            }
            AttributeInstance attributeInstance = entity.m_21051_(attribute);
            if (attributeInstance == null) continue;
            HashSet attributeModifiers = new HashSet(attributeInstance.m_22122_());
            for (AttributeModifier modifier : attributeModifiers) {
                if (!this.isId(modifier.m_22209_())) continue;
                attributeInstance.m_22120_(modifier.m_22209_());
            }
        }
    }

    protected UUID getId(UUID uuid) {
        return new UUID(uuid.getMostSignificantBits(), this.leastSignificantBits);
    }

    protected boolean isId(UUID uuid) {
        return uuid.getLeastSignificantBits() == this.leastSignificantBits;
    }

    public static class Properties {
        @Expose
        private final ModifierType type;
        @Expose
        private final double amount;
        @Expose
        private final ScalarReputationProperty reputation;

        public Properties(ModifierType type, double amount, ScalarReputationProperty reputation) {
            this.type = type;
            this.amount = amount;
            this.reputation = reputation;
        }

        public ModifierType getType() {
            return this.type;
        }

        public double getAmount() {
            return this.amount;
        }

        public double getAmount(ModifierContext context) {
            return this.reputation != null ? this.reputation.apply(this.amount, context) : this.amount;
        }
    }

    public static enum ModifierType {
        MAX_HEALTH_ADDITIVE(List.of(new ResourceLocation("generic.max_health")), AttributeModifier.Operation.ADDITION, Constants.DESCRIPTION_FORMATTER_ADDITIVE),
        MAX_HEALTH_ADDITIVE_PERCENTILE(List.of(new ResourceLocation("generic.max_health")), AttributeModifier.Operation.MULTIPLY_BASE, Constants.DESCRIPTION_FORMATTER_ADDITIVE_PERCENTILE),
        MAX_HEALTH_MULTIPLICATIVE_PERCENTILE(List.of(new ResourceLocation("generic.max_health")), AttributeModifier.Operation.MULTIPLY_TOTAL, Constants.DESCRIPTION_FORMATTER_MULTIPLICATIVE_PERCENTILE),
        ATTACK_DAMAGE_ADDITIVE_PERCENTILE(List.of(new ResourceLocation("generic.attack_damage")), AttributeModifier.Operation.MULTIPLY_BASE, Constants.DESCRIPTION_FORMATTER_ADDITIVE_PERCENTILE),
        SPEED_ADDITIVE_PERCENTILE(List.of(new ResourceLocation("generic.movement_speed"), new ResourceLocation("generic.flying_speed")), AttributeModifier.Operation.MULTIPLY_BASE, Constants.DESCRIPTION_FORMATTER_ADDITIVE_PERCENTILE),
        MANA_MAX_ADDITIVE(List.of(VaultMod.id("generic.mana_max")), AttributeModifier.Operation.ADDITION, Constants.DESCRIPTION_FORMATTER_ADDITIVE),
        MANA_MAX_ADDITIVE_PERCENTILE(List.of(VaultMod.id("generic.mana_max")), AttributeModifier.Operation.MULTIPLY_BASE, Constants.DESCRIPTION_FORMATTER_ADDITIVE_PERCENTILE),
        MANA_REGEN_ADDITIVE(List.of(VaultMod.id("generic.mana_regen")), AttributeModifier.Operation.ADDITION, Constants.DESCRIPTION_FORMATTER_ADDITIVE),
        MANA_REGEN_ADDITIVE_PERCENTILE(List.of(VaultMod.id("generic.mana_regen")), AttributeModifier.Operation.MULTIPLY_BASE, Constants.DESCRIPTION_FORMATTER_ADDITIVE_PERCENTILE),
        CRIT_CHANCE_ADDITIVE(List.of(VaultMod.id("generic.crit_chance")), AttributeModifier.Operation.ADDITION, Constants.DESCRIPTION_FORMATTER_ADDITIVE),
        KNOCKBACK_RESISTANCE_ADDITIVE(List.of(new ResourceLocation("generic.knockback_resistance")), AttributeModifier.Operation.ADDITION, Constants.DESCRIPTION_FORMATTER_ADDITIVE),
        DURABILITY_WEAR_REDUCTION_CAP_ADDITIVE(List.of(new ResourceLocation("generic.durability_wear_reduction_cap")), AttributeModifier.Operation.ADDITION, Constants.DESCRIPTION_FORMATTER_ADDITIVE);

        private final List<ResourceLocation> attributeResourceLocations;
        private final AttributeModifier.Operation attributeModifierOperation;
        private final IVaultModifierTextFormatter<Properties> descriptionFormatter;

        private ModifierType(List<ResourceLocation> attributeResourceLocations, AttributeModifier.Operation attributeModifierOperation, IVaultModifierTextFormatter<Properties> descriptionFormatter) {
            this.attributeResourceLocations = attributeResourceLocations;
            this.attributeModifierOperation = attributeModifierOperation;
            this.descriptionFormatter = descriptionFormatter;
        }

        public List<ResourceLocation> getAttributeResourceLocations() {
            return this.attributeResourceLocations;
        }

        public AttributeModifier.Operation getAttributeModifierOperation() {
            return this.attributeModifierOperation;
        }

        public <P extends Properties> IVaultModifierTextFormatter<P> getDescriptionFormatter() {
            return this.descriptionFormatter;
        }

        private static class Constants {
            public static final IVaultModifierTextFormatter<Properties> DESCRIPTION_FORMATTER_ADDITIVE = (t, p, s) -> t.formatted(Mth.m_14107_((double)Math.abs(p.getAmount() * (double)s)));
            public static final IVaultModifierTextFormatter<Properties> DESCRIPTION_FORMATTER_ADDITIVE_PERCENTILE = (t, p, s) -> t.formatted((int)(Math.abs(p.getAmount()) * (double)s * 100.0));
            public static final IVaultModifierTextFormatter<Properties> DESCRIPTION_FORMATTER_MULTIPLICATIVE_PERCENTILE = (t, p, s) -> t.formatted((int)(Math.abs(p.getAmount()) * (double)s * 100.0));

            private Constants() {
            }
        }
    }
}

