/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.modifier.spi.predicate;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.ISimpleAdapter;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.modifier.spi.predicate.GroupModifierPredicate;
import iskallia.vault.core.vault.modifier.spi.predicate.IdModifierPredicate;
import iskallia.vault.core.vault.modifier.spi.predicate.OrModifierPredicate;
import iskallia.vault.core.vault.modifier.spi.predicate.TypeModifierPredicate;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

@FunctionalInterface
public interface ModifierPredicate {
    public static final ModifierPredicate FALSE = modifier -> false;
    public static final ModifierPredicate TRUE = modifier -> true;

    public boolean test(VaultModifier<?> var1);

    public static Optional<ModifierPredicate> of(String string, boolean logErrors) {
        if (string.isEmpty()) {
            return Optional.of(TRUE);
        }
        return (switch (string.charAt(0)) {
            case '#' -> TypeModifierPredicate.parse(string, logErrors);
            case '@' -> GroupModifierPredicate.parse(string, logErrors);
            default -> IdModifierPredicate.parse(string, logErrors);
        }).map(predicate -> predicate);
    }

    public static class Adapter
    implements ISimpleAdapter<ModifierPredicate, Tag, JsonElement> {
        private static ArrayAdapter<ModifierPredicate> LIST = Adapters.ofArray(ModifierPredicate[]::new, new Adapter());

        @Override
        public void writeBits(@Nullable ModifierPredicate value, BitBuffer buffer) {
            buffer.writeBoolean(value == null);
            if (value != null) {
                if (value instanceof OrModifierPredicate) {
                    OrModifierPredicate or = (OrModifierPredicate)value;
                    buffer.writeBoolean(true);
                    LIST.writeBits((ModifierPredicate)or.getChildren(), buffer);
                } else {
                    buffer.writeBoolean(false);
                    Adapters.UTF_8.writeBits(value.toString(), buffer);
                }
            }
        }

        @Override
        public final Optional<ModifierPredicate> readBits(BitBuffer buffer) {
            if (buffer.readBoolean()) {
                return Optional.empty();
            }
            if (buffer.readBoolean()) {
                return LIST.readBits(buffer).map(OrModifierPredicate::new);
            }
            return Adapters.UTF_8.readBits(buffer).map(string -> ModifierPredicate.of(string, true).orElse(FALSE));
        }

        @Override
        public Optional<Tag> writeNbt(@Nullable ModifierPredicate value) {
            if (value == null) {
                return Optional.empty();
            }
            if (value instanceof OrModifierPredicate) {
                OrModifierPredicate or = (OrModifierPredicate)value;
                return LIST.writeNbt((ModifierPredicate)or.getChildren());
            }
            return Optional.of(StringTag.m_129297_((String)value.toString()));
        }

        @Override
        public Optional<ModifierPredicate> readNbt(@Nullable Tag nbt) {
            if (nbt == null) {
                return Optional.empty();
            }
            if (nbt instanceof ListTag) {
                ListTag list = (ListTag)nbt;
                return LIST.readNbt(list).map(OrModifierPredicate::new);
            }
            if (nbt instanceof StringTag) {
                StringTag string = (StringTag)nbt;
                return Optional.of(ModifierPredicate.of(string.m_7916_(), true).orElse(FALSE));
            }
            return Optional.empty();
        }

        @Override
        public Optional<JsonElement> writeJson(@Nullable ModifierPredicate value) {
            if (value == null) {
                return Optional.empty();
            }
            if (value instanceof OrModifierPredicate) {
                OrModifierPredicate or = (OrModifierPredicate)value;
                return LIST.writeJson((ModifierPredicate)or.getChildren());
            }
            return Optional.of(new JsonPrimitive(value.toString()));
        }

        @Override
        public Optional<ModifierPredicate> readJson(@Nullable JsonElement json) {
            JsonPrimitive primitive;
            if (json == null) {
                return Optional.empty();
            }
            if (json instanceof JsonArray) {
                JsonArray array = (JsonArray)json;
                return LIST.readJson(array).map(OrModifierPredicate::new);
            }
            if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString()) {
                return Optional.of(ModifierPredicate.of(json.getAsString(), true).orElse(FALSE));
            }
            return Optional.empty();
        }
    }
}

