/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.VaultMod;
import iskallia.vault.block.entity.HologramTileEntity;
import iskallia.vault.block.entity.hologram.HologramElement;
import iskallia.vault.block.entity.hologram.ItemHologramElement;
import iskallia.vault.block.entity.hologram.RootHologramElement;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.vault.CompoundAdapter;
import iskallia.vault.core.data.adapter.vault.DirectAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.PaletteKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.TemplatePoolKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.util.RegionPos;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.ClassicPortalLogic;
import iskallia.vault.core.vault.PortalLogic;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.objective.RuneBossObjective;
import iskallia.vault.core.world.generator.GridGenerator;
import iskallia.vault.core.world.generator.VaultGenerator;
import iskallia.vault.core.world.generator.layout.ArchitectRoomEntry;
import iskallia.vault.core.world.generator.layout.ClassicInfiniteLayout;
import iskallia.vault.core.world.generator.layout.GridLayout;
import iskallia.vault.core.world.generator.layout.VaultGridLayout;
import iskallia.vault.core.world.generator.layout.VaultLayout;
import iskallia.vault.core.world.processor.Palette;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.core.world.template.data.TemplatePool;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.crystal.layout.preset.PoolKeyTemplatePreset;
import iskallia.vault.item.crystal.layout.preset.StructurePreset;
import iskallia.vault.item.data.InscriptionData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class ArchitectObjective
extends Objective {
    public static final SupplierKey<Objective> KEY = (SupplierKey)SupplierKey.of("architect", Objective.class).with(Version.v1_26, (Objective)((Object)((Supplier<Objective>)ArchitectObjective::new)));
    public static final FieldRegistry FIELDS = Objective.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<ArchitectRoomEntry.List> ROOM_ENTRIES = (FieldKey)FieldKey.of("room_entries", ArchitectRoomEntry.List.class).with(Version.v1_26, CompoundAdapter.of(ArchitectRoomEntry.List::new), DISK.all()).register(FIELDS);
    public static final FieldKey<StructurePreset> PRESET = (FieldKey)FieldKey.of("preset", StructurePreset.class).with(Version.v1_26, Adapters.of(StructurePreset::new, true), DISK.all()).with(Version.v1_30, new DirectAdapter<StructurePreset>((value, buffer, context) -> Adapters.COMPOUND_NBT.asNullable().writeBits(value == null ? null : (CompoundTag)value.writeNbt().orElse(null), buffer), (buffer, context) -> Adapters.COMPOUND_NBT.asNullable().readBits(buffer).map(nbt -> {
        StructurePreset preset = new StructurePreset();
        preset.readNbt((CompoundTag)nbt);
        return preset;
    })), DISK.all()).register(FIELDS);

    protected ArchitectObjective() {
        this.set(ROOM_ENTRIES, new ArchitectRoomEntry.List());
    }

    public static ArchitectObjective create(Collection<ArchitectRoomEntry> roomEntries) {
        ArchitectObjective objective = new ArchitectObjective();
        objective.get(ROOM_ENTRIES).addAll(roomEntries);
        return objective;
    }

    @Override
    public SupplierKey<Objective> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault) {
        VaultGridLayout l;
        GridGenerator grid;
        GridLayout gridLayout;
        VaultGenerator generator = vault.get(Vault.WORLD).get(WorldManager.GENERATOR);
        VaultGridLayout vaultGridLayout = generator instanceof GridGenerator ? ((gridLayout = (grid = (GridGenerator)generator).get(GridGenerator.LAYOUT)) instanceof VaultGridLayout ? (l = (VaultGridLayout)gridLayout) : null) : null;
        VaultGridLayout layout = vaultGridLayout;
        List<TemplatePoolKey> entries = this.get(ROOM_ENTRIES).flatten(layout);
        JavaRandom random = JavaRandom.ofScrambled(vault.get(Vault.SEED));
        Collections.shuffle(entries, random.asRandomView());
        if (this.get(PRESET) == null && generator != null && layout != null) {
            StructurePreset preset = new StructurePreset();
            LinkedHashMap rings = new LinkedHashMap();
            List<Integer> weights = ModConfigs.INSCRIPTION.getRingWeights();
            RegionPos center = RegionPos.of(0, 0, generator.get(GridGenerator.CELL_X), generator.get(GridGenerator.CELL_Z));
            AtomicInteger noHits = new AtomicInteger(0);
            boolean hasRuneBoss = !vault.get(Vault.OBJECTIVES).getAll(RuneBossObjective.class).isEmpty();
            TemplatePoolKey bossKey = VaultRegistry.TEMPLATE_POOL.getKey(VaultMod.id("vault/rooms/special/boss"));
            HashSet bossRooms = new HashSet();
            int i = 0;
            while (true) {
                LinkedHashSet regions = new LinkedHashSet();
                AtomicBoolean noHit = new AtomicBoolean(true);
                this.iterateRing(center, i, region -> {
                    int n;
                    Direction facing = vault.get(Vault.WORLD).get(WorldManager.FACING);
                    if (layout instanceof ClassicInfiniteLayout) {
                        ClassicInfiniteLayout classicLayout = (ClassicInfiniteLayout)layout;
                        n = classicLayout.get(ClassicInfiniteLayout.TUNNEL_SPAN);
                    } else {
                        n = 0;
                    }
                    int tunnelSpan = n;
                    RegionPos back = region.add(facing, -(tunnelSpan + 1));
                    if (hasRuneBoss && back.m_123341_() == 0 && back.m_123343_() == 0) {
                        return;
                    }
                    if (layout.getType(vault, (RegionPos)((Object)region)) == VaultLayout.PieceType.ROOM) {
                        if (hasRuneBoss && bossKey != null && random.nextFloat() < 0.05f) {
                            preset.put((RegionPos)((Object)region), new PoolKeyTemplatePreset(bossKey));
                            bossRooms.add(region);
                        } else {
                            regions.add(region);
                        }
                        noHit.set(false);
                    }
                });
                if (noHit.get()) {
                    noHits.getAndAdd(1);
                } else {
                    noHits.set(0);
                }
                if (noHits.get() >= 3) break;
                if (!regions.isEmpty()) {
                    rings.put(i, regions);
                }
                if (rings.size() >= weights.size() && rings.values().stream().mapToInt(Set::size).sum() >= entries.size()) break;
                ++i;
            }
            if (hasRuneBoss) {
                for (Set regionSet : rings.values()) {
                    regionSet.removeIf(bossRooms::contains);
                }
                rings.entrySet().removeIf(entry -> ((Set)entry.getValue()).isEmpty());
            }
            for (i = entries.size() - 1; i >= 0; --i) {
                TemplatePoolKey entry2 = entries.get(i);
                WeightedList<Integer> weightedRings = new WeightedList<Integer>();
                ArrayList ringIndices = new ArrayList(rings.keySet());
                for (int j = 0; j < Math.min(rings.size(), weights.size()); ++j) {
                    weightedRings.add((Integer)ringIndices.get(j), weights.get(j));
                }
                weightedRings.getRandom(random).ifPresent(ringIndex -> {
                    Set ring = (Set)rings.get(ringIndex);
                    int randomEntry = random.nextInt(ring.size());
                    RegionPos randomPos = ring.stream().skip(randomEntry).findFirst().orElse(null);
                    if (randomPos != null) {
                        ring.remove((Object)randomPos);
                        preset.put(randomPos, new PoolKeyTemplatePreset(entry2));
                        if (ring.isEmpty()) {
                            rings.remove(ringIndex);
                        }
                    }
                });
                entries.remove(i);
            }
            this.set(PRESET, preset);
        }
        CommonEvents.LAYOUT_TEMPLATE_GENERATION.register(this, data -> {
            if (data.getVault() != vault) {
                return;
            }
            this.ifPresent(PRESET, preset -> {
                Object patt9301$temp = preset.get(data.getRegion()).orElse(null);
                if (patt9301$temp instanceof PoolKeyTemplatePreset) {
                    PoolKeyTemplatePreset entry = patt9301$temp;
                    TemplatePoolKey key = VaultRegistry.TEMPLATE_POOL.getKey(entry.getPool());
                    if (key == null) {
                        return;
                    }
                    if (data.getTemplate() != null) {
                        return;
                    }
                    data.setTemplate(data.getLayout().getRoom((TemplatePool)key.get(vault.get(Vault.VERSION)), vault, vault.get(Vault.VERSION), data.getRegion(), data.getRandom(), data.getSettings()));
                    if (key.getId().toString().contains("special/boss")) {
                        ResourceLocation theme = vault.get(Vault.WORLD).get(WorldManager.THEME);
                        ResourceLocation id = new ResourceLocation(theme.toString().replace("classic_vault_", "universal_"));
                        PaletteKey palette = VaultRegistry.PALETTE.getKey(id);
                        if (id.toString().contains("chaos")) {
                            palette = VaultRegistry.PALETTE.getKey(VaultMod.id("universal_sweet"));
                        }
                        data.getSettings().addProcessor((Palette)palette.get(Version.latest()));
                    }
                }
            });
        });
        super.initServer(world, vault);
    }

    public void iterateRing(RegionPos center, int distance, Consumer<RegionPos> runnable) {
        for (int i = -distance; i <= distance; ++i) {
            runnable.accept(center.with(i, distance));
            runnable.accept(center.with(i, -distance));
            runnable.accept(center.with(distance, i));
            runnable.accept(center.with(-distance, i));
        }
    }

    @Override
    public void tickServer(VirtualWorld world, Vault vault) {
        PortalLogic portalLogic = vault.get(Vault.WORLD).get(WorldManager.PORTAL_LOGIC);
        if (portalLogic instanceof ClassicPortalLogic) {
            ClassicPortalLogic logic = (ClassicPortalLogic)portalLogic;
            logic.getPlayerStartPos(vault).ifPresent(pos -> {
                if (world.m_7702_(pos = pos.m_6625_(3).m_5484_(vault.get(Vault.WORLD).get(WorldManager.FACING), 1)) instanceof HologramTileEntity) {
                    return;
                }
                world.m_7731_((BlockPos)pos, ModBlocks.HOLOGRAM.m_49966_(), 3);
                BlockEntity patt11575$temp = world.m_7702_((BlockPos)pos);
                if (patt11575$temp instanceof HologramTileEntity) {
                    HologramTileEntity entity = (HologramTileEntity)patt11575$temp;
                    entity.setTree(this.createHologram(entity, vault, world, (BlockPos)pos));
                }
            });
        }
        super.tickServer(world, vault);
    }

    private HologramElement createHologram(HologramTileEntity entity, Vault vault, VirtualWorld world, BlockPos pos) {
        RootHologramElement root = (RootHologramElement)((HologramElement)new RootHologramElement(entity).setTranslation(new Vec3(0.0, -1.5, 0.0))).setEulerRotation(new Vec3(90.0, 0.0, 0.0));
        HashSet<BlockPos> floor = new HashSet<BlockPos>();
        floor.add(pos);
        TemplatePoolKey bossKey = VaultRegistry.TEMPLATE_POOL.getKey(VaultMod.id("vault/rooms/special/boss"));
        AtomicBoolean hasNonBossRooms = new AtomicBoolean(false);
        this.get(PRESET).getAll().forEach((region, entry) -> {
            if (entry instanceof PoolKeyTemplatePreset) {
                GridGenerator generator;
                GridLayout patt13223$temp;
                PoolKeyTemplatePreset preset = (PoolKeyTemplatePreset)entry;
                if (preset.getPool().equals((Object)(bossKey != null ? bossKey.getId() : null))) {
                    return;
                }
                hasNonBossRooms.set(true);
                ItemStack inscription = new ItemStack((ItemLike)ModItems.INSCRIPTION);
                InscriptionData data = InscriptionData.from(inscription);
                data.setModel(ModConfigs.INSCRIPTION.getModel(preset.getPool()));
                data.write(inscription);
                int x = region.m_123341_();
                int z = region.m_123343_();
                VaultGenerator patt13140$temp = vault.get(Vault.WORLD).get(WorldManager.GENERATOR);
                if (patt13140$temp instanceof GridGenerator && (patt13223$temp = (generator = (GridGenerator)patt13140$temp).get(GridGenerator.LAYOUT)) instanceof ClassicInfiniteLayout) {
                    ClassicInfiniteLayout layout = (ClassicInfiniteLayout)patt13223$temp;
                    x /= layout.get(ClassicInfiniteLayout.TUNNEL_SPAN) + 1;
                    z /= layout.get(ClassicInfiniteLayout.TUNNEL_SPAN) + 1;
                }
                floor.add(pos.m_142082_(x, 0, z));
                HologramElement[] hologramElementArray = new HologramElement[1];
                Object t = new ItemHologramElement(inscription, true, true).setTranslation(new Vec3((double)x, (double)(-z), 0.0));
                hologramElementArray[0] = ((HologramElement)t).setEulerRotation(switch (vault.get(Vault.WORLD).get(WorldManager.FACING)) {
                    case Direction.NORTH -> new Vec3(0.0, 0.0, 180.0);
                    case Direction.EAST -> new Vec3(0.0, 0.0, 90.0);
                    case Direction.WEST -> new Vec3(0.0, 0.0, -90.0);
                    default -> Vec3.f_82478_;
                });
                root.add(hologramElementArray);
            }
        });
        if (!hasNonBossRooms.get() || floor.isEmpty()) {
            return root;
        }
        int size = 0;
        for (BlockPos p : floor) {
            size = Math.max(size, Math.abs(p.m_123341_() - pos.m_123341_()));
            size = Math.max(size, Math.abs(p.m_123343_() - pos.m_123343_()));
        }
        for (int x = -size; x <= size; ++x) {
            for (int z = -size; z <= size; ++z) {
                BlockPos block = pos.m_142082_(x, 0, z);
                if (floor.contains(block)) {
                    world.m_7731_(block.m_6630_(1), ModBlocks.VAULT_STONE.m_49966_(), 3);
                    continue;
                }
                world.m_7731_(block.m_6630_(1), ModBlocks.POLISHED_VAULT_STONE.m_49966_(), 3);
            }
        }
        world.m_7731_(pos.m_6630_(1), ModBlocks.CHISELED_VAULT_STONE.m_49966_(), 3);
        return root;
    }

    @Override
    public boolean render(Vault vault, PoseStack matrixStack, Window window, float partialTicks, Player player) {
        return false;
    }

    @Override
    public boolean isActive(VirtualWorld world, Vault vault, Objective objective) {
        return objective == this;
    }
}

