/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.block.VaultCrateBlock;
import iskallia.vault.config.LegacyLootTablesConfig;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.data.adapter.vault.CompoundAdapter;
import iskallia.vault.core.data.adapter.vault.RegistryKeyAdapter;
import iskallia.vault.core.data.compound.ItemStackList;
import iskallia.vault.core.data.compound.UUIDList;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.LootTableKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.CrateAwardEvent;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.vault.CrateLootGenerator;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultLevel;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.vault.modifier.modifier.NoCrateModifier;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.init.ModConfigs;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class AwardCrateObjective
extends Objective {
    public static final SupplierKey<Objective> KEY = (SupplierKey)SupplierKey.of("award_crate", Objective.class).with(Version.v1_0, (Objective)((Object)((Supplier<Objective>)AwardCrateObjective::new)));
    public static final FieldRegistry FIELDS = Objective.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<VaultCrateBlock.Type> TYPE = (FieldKey)FieldKey.of("type", VaultCrateBlock.Type.class).with(Version.v1_0, Adapters.ofEnum(VaultCrateBlock.Type.class, EnumAdapter.Mode.ORDINAL), DISK.all()).register(FIELDS);
    public static final FieldKey<LootTableKey> LOOT_TABLE = (FieldKey)FieldKey.of("loot_table", LootTableKey.class).with(Version.v1_0, RegistryKeyAdapter.of(() -> VaultRegistry.LOOT_TABLE).asNullable(), DISK.all()).register(FIELDS);
    public static final FieldKey<Float> ITEM_QUANTITY = (FieldKey)FieldKey.of("item_quantity", Float.class).with(Version.v1_23, Adapters.FLOAT, DISK.all()).register(FIELDS);
    public static final FieldKey<Void> ADD_ARTIFACT = (FieldKey)FieldKey.of("add_artifact", Void.class).with(Version.v1_0, Adapters.ofVoid(), DISK.all()).register(FIELDS);
    public static final FieldKey<Float> ARTIFACT_CHANCE = (FieldKey)FieldKey.of("artifact_chance", Float.class).with(Version.v1_0, Adapters.FLOAT, DISK.all()).register(FIELDS);
    public static final FieldKey<Void> AWARDED = (FieldKey)FieldKey.of("awarded", Void.class).with(Version.v1_0, Adapters.ofVoid(), DISK.all()).register(FIELDS);
    public static final FieldKey<UUIDList> AWARDED_PLAYERS = (FieldKey)FieldKey.of("awarded_players", UUIDList.class).with(Version.v1_1, CompoundAdapter.of(UUIDList::create), DISK.all()).register(FIELDS);
    public static final FieldKey<ItemStackList> ADDITIONAL_ITEMS = (FieldKey)FieldKey.of("additional_items", ItemStackList.class).with(Version.v1_28, CompoundAdapter.of(ItemStackList::create), DISK.all()).register(FIELDS);
    public static final FieldKey<Integer> LOOT_MULTIPLIER = (FieldKey)FieldKey.of("loot_multiplier", Integer.class).with(Version.v1_37, Adapters.INT_SEGMENTED_7, DISK.all()).register(FIELDS);

    protected AwardCrateObjective() {
        this.set(LOOT_MULTIPLIER, 1);
    }

    public static AwardCrateObjective ofConfig(VaultCrateBlock.Type type, String id, int level, boolean hasArtifact) {
        ResourceLocation completionCrate;
        LegacyLootTablesConfig.Level config = ModConfigs.LOOT_TABLES.getForLevel(level);
        AwardCrateObjective objective = new AwardCrateObjective();
        if (config != null && (completionCrate = config.getCompletionCrate(id)) != null) {
            ((Objective)objective.set(TYPE, type)).set(LOOT_TABLE, VaultRegistry.LOOT_TABLE.getKey(completionCrate));
        }
        if (hasArtifact) {
            ((Objective)objective.set(ADD_ARTIFACT)).set(ARTIFACT_CHANCE, Float.valueOf(config == null ? 0.0f : config.getArtifactChance()));
        }
        objective.set(AWARDED_PLAYERS, UUIDList.create());
        return objective;
    }

    @Override
    public SupplierKey<Objective> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    public void tickServer(VirtualWorld world, Vault vault) {
        if (vault.get(Vault.VERSION) == Version.v1_0 && !this.has(AWARDED)) {
            ChunkRandom random = ChunkRandom.any();
            random.setSeed(vault.get(Vault.SEED));
            vault.ifPresent(Vault.LISTENERS, listeners -> {
                for (Listener listener : listeners.getAll()) {
                    if (!(listener instanceof Runner)) continue;
                    this.awardCrate(vault, listener, random);
                }
            });
            this.set(AWARDED);
        }
        if (!this.has(AWARDED)) {
            this.set(AWARDED);
            CommonEvents.LISTENER_LEAVE.register(this, data -> {
                Listener listener = data.getListener();
                if (!(listener instanceof Runner)) {
                    return;
                }
                Runner runner = (Runner)listener;
                if (this.has(AWARDED_PLAYERS) && this.get(AWARDED_PLAYERS).contains(listener.get(Listener.ID))) {
                    return;
                }
                ChunkRandom random = ChunkRandom.any();
                random.setSeed(vault.get(Vault.SEED) ^ listener.getId().getLeastSignificantBits());
                this.awardCrate(vault, listener, random);
                if (this.has(AWARDED_PLAYERS)) {
                    this.get(AWARDED_PLAYERS).add(listener.get(Listener.ID));
                }
            });
        }
        super.tickServer(world, vault);
    }

    @Override
    public void tickListener(VirtualWorld world, Vault vault, Listener listener) {
        if (!VaultUtils.isBrazierVault(vault) && listener instanceof Runner && this.has(AWARDED_PLAYERS) && !this.get(AWARDED_PLAYERS).contains(listener.get(Listener.ID))) {
            ChunkRandom random = ChunkRandom.any();
            random.setSeed(vault.get(Vault.SEED) ^ listener.getId().getLeastSignificantBits());
            this.awardCrate(vault, listener, random);
            this.get(AWARDED_PLAYERS).add(listener.get(Listener.ID));
        }
        super.tickListener(world, vault, listener);
    }

    protected void awardCrate(Vault vault, Listener listener, ChunkRandom random) {
        if (!vault.has(Vault.STATS)) {
            return;
        }
        if (vault.get(Vault.MODIFIERS).getModifiers().stream().anyMatch(m -> m instanceof NoCrateModifier)) {
            return;
        }
        StatCollector stats = vault.get(Vault.STATS).get(listener.get(Listener.ID));
        if (stats == null) {
            return;
        }
        int level = vault.getOptional(Vault.LEVEL).map(VaultLevel::get).orElse(0);
        float xpMul = Mth.m_14036_((float)stats.getExpMultiplier(), (float)0.0f, (float)1.0f);
        float artifactChance = this.has(ARTIFACT_CHANCE) ? this.get(ARTIFACT_CHANCE).floatValue() * xpMul : 0.0f;
        ArrayList<ItemStack> additional = new ArrayList<ItemStack>(this.getOr(ADDITIONAL_ITEMS, ItemStackList.create()));
        if (listener instanceof Runner) {
            Runner runner = (Runner)listener;
            additional.addAll(runner.getOr(Runner.ADDITIONAL_CRATE_ITEMS, ItemStackList.create()));
        }
        CrateLootGenerator crateLootGenerator = new CrateLootGenerator(this.get(LOOT_TABLE), this.getOr(ITEM_QUANTITY, Float.valueOf(0.0f)).floatValue(), additional, this.has(ADD_ARTIFACT), artifactChance);
        VaultCrateBlock.Type crateType = this.get(TYPE);
        listener.getPlayer().ifPresent(player -> CommonEvents.CRATE_AWARD_EVENT.invoke((ServerPlayer)player, ItemStack.f_41583_, crateLootGenerator, vault, listener, crateType, List.of(), vault.get(Vault.VERSION), random, CrateAwardEvent.Phase.PRE));
        NonNullList<ItemStack> items = crateLootGenerator.generate(vault, listener, random);
        ItemStack crate = VaultCrateBlock.getCrateWithLootWithAntiques(crateType, level, items, listener.getPlayer().orElse(null));
        if (this.has(LOOT_MULTIPLIER) && this.get(LOOT_MULTIPLIER) > 1) {
            int lootMultiplier = this.get(LOOT_MULTIPLIER);
            for (ItemStack item : items) {
                item.m_41764_(lootMultiplier * item.m_41613_());
            }
        }
        listener.getPlayer().ifPresent(player -> CommonEvents.CRATE_AWARD_EVENT.invoke((ServerPlayer)player, crate, crateLootGenerator, vault, listener, crateType, (List<ItemStack>)items, vault.get(Vault.VERSION), random, CrateAwardEvent.Phase.POST));
        stats.get(StatCollector.REWARD).add(crate);
    }

    @Override
    public boolean render(Vault vault, PoseStack matrixStack, Window window, float partialTicks, Player player) {
        return false;
    }

    @Override
    public boolean isActive(VirtualWorld world, Vault vault, Objective objective) {
        return objective == this;
    }
}

