/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataMap;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.vault.CompoundAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.ClientEvents;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.objective.PvPObjective;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.init.ModKeybinds;
import iskallia.vault.task.BingoTask;
import iskallia.vault.task.ProgressConfiguredTask;
import iskallia.vault.task.Task;
import iskallia.vault.task.TaskContext;
import iskallia.vault.task.counter.TargetTaskCounter;
import iskallia.vault.task.counter.TaskCounter;
import iskallia.vault.task.renderer.context.TaskRendererContext;
import iskallia.vault.task.source.EntityTaskSource;
import iskallia.vault.task.source.TaskSource;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BingoObjective
extends Objective {
    public static final SupplierKey<Objective> KEY = (SupplierKey)SupplierKey.of("bingo", Objective.class).with(Version.v1_27, (Objective)((Object)((Supplier<Objective>)BingoObjective::new)));
    public static final FieldRegistry FIELDS = Objective.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<Task> TASK = (FieldKey)FieldKey.of("task", Task.class).with(Version.v1_27, Adapters.TASK_NBT, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<TaskSource> TASK_SOURCE = (FieldKey)FieldKey.of("task_source", TaskSource.class).with(Version.v1_27, Adapters.TASK_SOURCE_NBT, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Integer> JOINED = (FieldKey)FieldKey.of("joined", Integer.class).with(Version.v1_27, Adapters.INT_SEGMENTED_3, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<TaskMap> TASKS = (FieldKey)FieldKey.of("tasks", TaskMap.class).with(Version.v1_38, CompoundAdapter.of(TaskMap::new), DISK.all().or(CLIENT.all())).register(FIELDS);
    private boolean pvp;
    private int lastScaledJoined = -1;

    protected BingoObjective() {
        this.set(TASKS, new TaskMap());
    }

    public static BingoObjective of(BingoTask task) {
        return (BingoObjective)((Objective)new BingoObjective().set(TASK, task)).set(TASKS, new TaskMap());
    }

    @Override
    public SupplierKey<Objective> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    public TaskContext getContext(VirtualWorld world, Vault vault) {
        this.setIfAbsent(TASK_SOURCE, () -> EntityTaskSource.ofUuids(JavaRandom.ofInternal(vault.get(Vault.SEED)), new UUID[0]));
        return TaskContext.of(this.get(TASK_SOURCE), world.m_142572_()).setVault(vault);
    }

    private TaskContext getContext(VirtualWorld world, Vault vault, UUID uuid) {
        return TaskContext.of(EntityTaskSource.ofUuids(JavaRandom.ofInternal(vault.get(Vault.SEED)), uuid), world.m_142572_()).setVault(vault);
    }

    public boolean isCompleted() {
        BingoTask bingo;
        if (this.pvp) {
            return this.get(TASKS).values().stream().anyMatch(task -> {
                BingoTask bingo;
                return task instanceof BingoTask && (bingo = (BingoTask)task).areAllCompleted();
            });
        }
        Task task2 = this.get(TASK);
        return task2 instanceof BingoTask && (bingo = (BingoTask)task2).areAllCompleted();
    }

    public int getBingos() {
        int n;
        if (this.pvp) {
            return this.get(TASKS).values().stream().filter(task -> task instanceof BingoTask).map(task -> (BingoTask)task).mapToInt(BingoTask::getCompletedBingos).max().orElse(0);
        }
        Task task2 = this.get(TASK);
        if (task2 instanceof BingoTask) {
            BingoTask bingo = (BingoTask)task2;
            n = bingo.getCompletedBingos();
        } else {
            n = 0;
        }
        return n;
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault) {
        this.pvp = vault.get(Vault.OBJECTIVES).forEach(PvPObjective.class, obj -> true);
        CommonEvents.LISTENER_JOIN.register(this, data -> {
            if (data.getVault() != vault) {
                return;
            }
            Listener patt4799$temp = data.getListener();
            if (!(patt4799$temp instanceof Runner)) {
                return;
            }
            Runner runner = (Runner)patt4799$temp;
            if (this.pvp) {
                if (!this.get(TASKS).containsKey(runner.getId())) {
                    BingoTask board = (BingoTask)((BingoTask)this.get(TASK)).copy();
                    board.onAttach(this.getContext(world, vault, runner.getId()));
                    this.get(TASKS).put(runner.getId(), board);
                }
            } else {
                TaskSource patt5225$temp = this.get(TASK_SOURCE);
                if (patt5225$temp instanceof EntityTaskSource) {
                    EntityTaskSource entitySource = (EntityTaskSource)patt5225$temp;
                    entitySource.add(runner.getId());
                }
                this.set(JOINED, this.getOr(JOINED, 0) + 1);
            }
        });
        CommonEvents.LISTENER_LEAVE.register(this, data -> {
            if (data.getVault() != vault) {
                return;
            }
            Listener patt5575$temp = data.getListener();
            if (!(patt5575$temp instanceof Runner)) {
                return;
            }
            Runner runner = (Runner)patt5575$temp;
            if (this.pvp) {
                BingoTask board = (BingoTask)this.get(TASKS).remove(runner.getId());
                if (board != null) {
                    board.onDetach();
                }
            } else {
                TaskSource patt5819$temp = this.get(TASK_SOURCE);
                if (patt5819$temp instanceof EntityTaskSource) {
                    EntityTaskSource entitySource = (EntityTaskSource)patt5819$temp;
                    entitySource.remove(runner.getId());
                }
            }
        });
        this.get(TASK).onAttach(this.getContext(world, vault));
        if (this.pvp) {
            for (Runner runner : vault.get(Vault.LISTENERS).getAll(Runner.class)) {
                BingoTask board = (BingoTask)((BingoTask)this.get(TASK)).copy();
                board.onAttach(this.getContext(world, vault, runner.getId()));
                this.get(TASKS).put(runner.getId(), board);
            }
            this.get(TASK).onDetach();
        }
        CommonEvents.GRID_GATEWAY_UPDATE.register(this, data -> {
            if (data.getLevel() != world) {
                return;
            }
            data.getEntity().setCompletedBingos(this.getBingos());
        });
        super.initServer(world, vault);
    }

    @Override
    public void tickServer(VirtualWorld world, Vault vault) {
        if (this.getBingos() > 0) {
            super.tickServer(world, vault);
            if (this.isCompleted()) {
                return;
            }
        }
        if (this.pvp) {
            this.get(TASKS).forEach((uuid, task) -> {
                if (task instanceof BingoTask) {
                    BingoTask bingo = (BingoTask)task;
                    bingo.onTick(this.getContext(world, vault, (UUID)uuid));
                }
            });
        } else {
            Task task2 = this.get(TASK);
            if (task2 instanceof BingoTask) {
                BingoTask bingo = (BingoTask)task2;
                bingo.onTick(this.getContext(world, vault));
            }
        }
        if (world.getTickCount() % 20 == 0) {
            Task task3;
            int joined = this.getOr(JOINED, 0);
            if (this.pvp) {
                this.get(TASKS).values().forEach(task -> {
                    if (!(task instanceof BingoTask)) {
                        return;
                    }
                    BingoTask root = (BingoTask)task;
                    for (int index = 0; index < root.getWidth() * root.getHeight(); ++index) {
                        if (root.isCompleted(index)) continue;
                        root.getChild(index).streamSelfAndDescendants(ProgressConfiguredTask.class).forEach(t -> {
                            TargetTaskCounter counter;
                            TaskCounter patt7787$temp = t.getCounter();
                            if (!(patt7787$temp instanceof TargetTaskCounter) || !(counter = (TargetTaskCounter)patt7787$temp).isPopulated()) {
                                return;
                            }
                            counter.get("targetPlayerContribution", Adapters.DOUBLE).ifPresent(contribution -> {
                                Object patt8038$temp = counter.getBaseTarget();
                                if (patt8038$temp instanceof Integer) {
                                    Integer base = (Integer)patt8038$temp;
                                    counter.setTarget((int)((double)base.intValue() + contribution * (double)base.intValue()));
                                } else {
                                    Object patt8221$temp = counter.getBaseTarget();
                                    if (patt8221$temp instanceof Float) {
                                        Float base = (Float)patt8221$temp;
                                        counter.setTarget(Float.valueOf((float)((double)base.floatValue() + contribution * (double)base.floatValue())));
                                    }
                                }
                            });
                        });
                    }
                });
            } else if (joined != this.lastScaledJoined && (task3 = this.get(TASK)) instanceof BingoTask) {
                BingoTask root = (BingoTask)task3;
                this.lastScaledJoined = joined;
                for (int index = 0; index < root.getWidth() * root.getHeight(); ++index) {
                    if (root.isCompleted(index)) continue;
                    root.getChild(index).streamSelfAndDescendants(ProgressConfiguredTask.class).forEach(task -> {
                        TargetTaskCounter counter;
                        TaskCounter patt9064$temp = task.getCounter();
                        if (!(patt9064$temp instanceof TargetTaskCounter) || !(counter = (TargetTaskCounter)patt9064$temp).isPopulated()) {
                            return;
                        }
                        counter.get("targetPlayerContribution", Adapters.DOUBLE).ifPresent(contribution -> {
                            int additional = Math.max(joined - 1, 0);
                            Object patt9378$temp = counter.getBaseTarget();
                            if (patt9378$temp instanceof Integer) {
                                Integer base = (Integer)patt9378$temp;
                                counter.setTarget((int)((double)base.intValue() + (double)additional * contribution * (double)base.intValue()));
                            } else {
                                Object patt9566$temp = counter.getBaseTarget();
                                if (patt9566$temp instanceof Float) {
                                    Float base = (Float)patt9566$temp;
                                    counter.setTarget(Float.valueOf((float)((double)base.floatValue() + (double)additional * contribution * (double)base.floatValue())));
                                } else {
                                    throw new UnsupportedOperationException();
                                }
                            }
                        });
                    });
                }
            }
        }
    }

    @Override
    public void tickListener(VirtualWorld world, Vault vault, Listener listener) {
        if (listener instanceof Runner && listener.getPriority(this) < 0) {
            listener.addObjective(vault, this);
        }
        if (listener instanceof Runner) {
            Runner runner = (Runner)listener;
            if (this.pvp) {
                BingoTask task = (BingoTask)this.get(TASKS).get(runner.getId());
                if (task != null && task.getCompletedBingos() > 0) {
                    super.tickListener(world, vault, listener);
                }
            } else if (this.getBingos() > 0) {
                super.tickListener(world, vault, listener);
            }
        }
    }

    @Override
    public void releaseServer() {
        if (this.pvp) {
            this.get(TASKS).values().forEach(task -> {
                if (task != null) {
                    task.onDetach();
                }
            });
        } else {
            this.get(TASK).onDetach();
        }
        super.releaseServer();
    }

    public void onScroll(Player player, double delta) {
        if (this.pvp) {
            Task t;
            if (this.get(TASKS).containsKey(player.m_142081_()) && (t = (Task)this.get(TASKS).get(player.m_142081_())) instanceof BingoTask) {
                BingoTask board = (BingoTask)t;
                board.progressBingoLine(player.m_142081_(), delta < 0.0 ? 1 : -1);
            }
        } else {
            Task task = this.get(TASK);
            if (task instanceof BingoTask) {
                BingoTask bingo = (BingoTask)task;
                bingo.progressBingoLine(player.m_142081_(), delta < 0.0 ? 1 : -1);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initClient(Vault vault) {
        this.pvp = vault.get(Vault.OBJECTIVES).forEach(PvPObjective.class, obj -> true);
        ClientEvents.MOUSE_SCROLL.register(vault, event -> {
            Task task;
            if (Minecraft.m_91087_().f_91080_ != null || !ModKeybinds.openBingo.m_90857_()) {
                return;
            }
            TaskRendererContext context = new TaskRendererContext(null, 0.0f, MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_()), Minecraft.m_91087_().f_91062_);
            UUID uuid = Minecraft.m_91087_().f_91074_ != null ? Minecraft.m_91087_().f_91074_.m_142081_() : null;
            context.setUuid(uuid);
            Task task2 = task = this.pvp && uuid != null ? (Task)this.get(TASKS).get(uuid) : this.get(TASK);
            if (task != null && task.onMouseScrolled(event.getScrollDelta(), context)) {
                event.setCanceled(true);
            }
        });
        super.initClient(vault);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean render(Vault vault, PoseStack poseStack, Window window, float partialTicks, Player player) {
        Task task;
        PvPObjective objective;
        List<PvPObjective> objs = vault.get(Vault.OBJECTIVES).getAll(PvPObjective.class);
        if (!objs.isEmpty() && !(objective = objs.get(0)).has(PvPObjective.COUNTDOWN_FINISHED)) {
            return false;
        }
        if (this.isCompleted() && (Minecraft.m_91087_().f_91080_ != null || !ModKeybinds.openBingo.m_90857_())) {
            boolean rendered = false;
            for (Objective objective2 : (Objective.ObjList)this.get(CHILDREN)) {
                rendered |= objective2.render(vault, poseStack, window, partialTicks, player);
            }
            if (rendered) {
                return true;
            }
        }
        Task task2 = task = this.pvp ? (Task)this.get(TASKS).get(player.m_142081_()) : this.get(TASK);
        if (task == null) {
            return true;
        }
        TaskRendererContext context = new TaskRendererContext(poseStack, partialTicks, MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_()), Minecraft.m_91087_().f_91062_);
        task.onRender(context);
        return true;
    }

    @Override
    public boolean isActive(VirtualWorld world, Vault vault, Objective objective) {
        if (!this.isCompleted()) {
            if (this.getBingos() > 0) {
                for (Objective child : (Objective.ObjList)this.get(CHILDREN)) {
                    if (!child.isActive(world, vault, objective)) continue;
                    return true;
                }
            }
            return objective == this;
        }
        for (Objective child : (Objective.ObjList)this.get(CHILDREN)) {
            if (!child.isActive(world, vault, objective)) continue;
            return true;
        }
        return false;
    }

    public static class TaskMap
    extends DataMap<TaskMap, UUID, Task> {
        public TaskMap() {
            super(new HashMap(), Adapters.UUID, Adapters.TASK_NBT);
        }
    }
}

